<?php
session_start();
if (!isset($_SESSION['admin_id'])) {
    header('Location: ../login.php');
    exit();
}

require_once '../config/database.php';
$conn = getConnection();

// Get statistics
$total_guru = $conn->query("SELECT COUNT(*) as count FROM guru WHERE status='aktif'")->fetch_assoc()['count'];
$total_siswa = $conn->query("SELECT COUNT(*) as count FROM siswa WHERE status='aktif'")->fetch_assoc()['count'];
$today = date('Y-m-d');
$total_hadir = $conn->query("SELECT COUNT(*) as count FROM absensi WHERE tanggal='$today' AND status='hadir'")->fetch_assoc()['count'];
$total_alpha = $conn->query("SELECT COUNT(*) as count FROM absensi WHERE tanggal='$today' AND status='alpha'")->fetch_assoc()['count'];

// Get data for chart (last 7 days)
$chart_data = [];
for ($i = 6; $i >= 0; $i--) {
    $date = date('Y-m-d', strtotime("-$i days"));
    $result = $conn->query("
        SELECT 
            SUM(CASE WHEN status='hadir' THEN 1 ELSE 0 END) as hadir,
            SUM(CASE WHEN status='izin' THEN 1 ELSE 0 END) as izin,
            SUM(CASE WHEN status='sakit' THEN 1 ELSE 0 END) as sakit,
            SUM(CASE WHEN status='alpha' THEN 1 ELSE 0 END) as alpha
        FROM absensi WHERE tanggal='$date'
    ")->fetch_assoc();
    
    $chart_data[] = [
        'date' => date('d M', strtotime($date)),
        'hadir' => $result['hadir'] ?? 0,
        'izin' => $result['izin'] ?? 0,
        'sakit' => $result['sakit'] ?? 0,
        'alpha' => $result['alpha'] ?? 0
    ];
}

// Get recent activities
$recent_activities = $conn->query("
    SELECT s.nama as siswa_nama, g.nama as guru_nama, a.tanggal, a.status, a.created_at
    FROM absensi a
    JOIN siswa s ON a.siswa_id = s.id
    JOIN guru g ON a.guru_id = g.id
    ORDER BY a.created_at DESC
    LIMIT 10
")->fetch_all(MYSQLI_ASSOC);

$conn->close();
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard Admin - SIPANCUR MOBILE</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Poppins', sans-serif;
            background: #f3f4f6;
            display: flex;
            min-height: 100vh;
        }
        
        /* Sidebar */
        .sidebar {
            width: 280px;
            background: white;
            box-shadow: 2px 0 10px rgba(0,0,0,0.08);
            position: fixed;
            left: 0;
            top: 0;
            bottom: 0;
            z-index: 1000;
            display: flex;
            flex-direction: column;
        }
        
        .sidebar-header {
            padding: 30px 25px;
            background: linear-gradient(135deg, #4ade80 0%, #22c55e 100%);
            color: white;
        }
        
        .sidebar-logo {
            display: flex;
            align-items: center;
            gap: 15px;
        }
        
        .sidebar-logo img {
            width: 50px;
            height: 50px;
            border-radius: 12px;
            border: 2px solid rgba(255,255,255,0.3);
            box-shadow: 0 4px 10px rgba(0,0,0,0.1);
        }
        
        .sidebar-logo-text h1 {
            font-size: 20px;
            font-weight: 700;
            margin-bottom: 2px;
        }
        
        .sidebar-logo-text p {
            font-size: 11px;
            opacity: 0.9;
            font-weight: 400;
        }
        
        .sidebar-user {
            padding: 25px;
            border-bottom: 1px solid #e5e7eb;
            background: #f9fafb;
        }
        
        .user-info {
            display: flex;
            align-items: center;
            gap: 15px;
        }
        
        .user-avatar {
            width: 50px;
            height: 50px;
            background: linear-gradient(135deg, #4ade80 0%, #22c55e 100%);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 20px;
            font-weight: 700;
            box-shadow: 0 4px 12px rgba(74, 222, 128, 0.3);
            flex-shrink: 0;
        }
        
        .user-details {
            flex: 1;
            min-width: 0;
        }
        
        .user-details h3 {
            font-size: 15px;
            font-weight: 600;
            color: #1f2937;
            margin: 0 0 3px 0;
            line-height: 1.2;
        }
        
        .user-details p {
            font-size: 12px;
            color: #6b7280;
            font-weight: 500;
            margin: 0;
            line-height: 1.2;
        }
        
        .sidebar-menu {
            flex: 1;
            padding: 25px 0;
            overflow-y: auto;
        }
        
        .menu-section {
            margin-bottom: 30px;
        }
        
        .menu-title {
            padding: 0 25px;
            font-size: 11px;
            font-weight: 700;
            color: #9ca3af;
            text-transform: uppercase;
            letter-spacing: 1px;
            margin-bottom: 10px;
        }
        
        .menu-item {
            display: flex;
            align-items: center;
            gap: 15px;
            padding: 14px 25px;
            margin: 0 15px;
            color: #6b7280;
            text-decoration: none;
            transition: all 0.3s;
            position: relative;
            border-radius: 10px;
        }
        
        .menu-item:hover {
            background: #f3f4f6;
            color: #22c55e;
        }
        
        .menu-item.active {
            background: linear-gradient(135deg, rgba(74, 222, 128, 0.15) 0%, rgba(34, 197, 94, 0.15) 100%);
            color: #22c55e;
            font-weight: 600;
        }
        
        .menu-item.active::before {
            content: '';
            position: absolute;
            left: -15px;
            top: 50%;
            transform: translateY(-50%);
            width: 4px;
            height: 70%;
            background: #22c55e;
            border-radius: 0 4px 4px 0;
        }
        
        .menu-item i {
            width: 22px;
            font-size: 20px;
            text-align: center;
        }
        
        .menu-item span {
            font-size: 14px;
            font-weight: 500;
        }
        
        .sidebar-footer {
            padding: 25px;
            border-top: 1px solid #e5e7eb;
            background: #f9fafb;
        }
        
        .btn-logout {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 10px;
            width: 100%;
            padding: 14px;
            background: linear-gradient(135deg, #f87171 0%, #ef4444 100%);
            color: white;
            text-decoration: none;
            border-radius: 12px;
            font-size: 14px;
            font-weight: 600;
            transition: all 0.3s;
            box-shadow: 0 4px 12px rgba(239, 68, 68, 0.2);
        }
        
        .btn-logout:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(239, 68, 68, 0.3);
        }
        
        .btn-logout:active {
            transform: translateY(0);
        }
        
        /* Main Content */
        .main-content {
            margin-left: 280px;
            flex: 1;
            padding: 30px;
        }
        
        .page-header {
            margin-bottom: 30px;
        }
        
        .page-header h2 {
            font-size: 28px;
            font-weight: 700;
            color: #1f2937;
            margin-bottom: 5px;
        }
        
        .page-header p {
            color: #6b7280;
            font-size: 14px;
        }
        
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(240px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }
        
        .stat-card {
            background: white;
            border-radius: 15px;
            padding: 25px;
            box-shadow: 0 4px 15px rgba(0,0,0,0.05);
            transition: all 0.3s;
        }
        
        .stat-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 25px rgba(0,0,0,0.1);
        }
        
        .stat-header {
            display: flex;
            align-items: center;
            justify-content: space-between;
            margin-bottom: 15px;
        }
        
        .stat-icon {
            width: 55px;
            height: 55px;
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 24px;
        }
        
        .stat-card.green .stat-icon {
            background: linear-gradient(135deg, #4ade80 0%, #22c55e 100%);
            color: white;
        }
        
        .stat-card.blue .stat-icon {
            background: linear-gradient(135deg, #60a5fa 0%, #3b82f6 100%);
            color: white;
        }
        
        .stat-card.yellow .stat-icon {
            background: linear-gradient(135deg, #fbbf24 0%, #f59e0b 100%);
            color: white;
        }
        
        .stat-card.red .stat-icon {
            background: linear-gradient(135deg, #f87171 0%, #ef4444 100%);
            color: white;
        }
        
        .stat-label {
            font-size: 13px;
            color: #6b7280;
            font-weight: 500;
            margin-bottom: 8px;
        }
        
        .stat-value {
            font-size: 32px;
            font-weight: 700;
            color: #1f2937;
        }
        
        .chart-card {
            background: white;
            border-radius: 15px;
            padding: 25px;
            box-shadow: 0 4px 15px rgba(0,0,0,0.05);
            margin-bottom: 30px;
        }
        
        .chart-header {
            display: flex;
            align-items: center;
            gap: 10px;
            margin-bottom: 20px;
        }
        
        .chart-header h3 {
            font-size: 18px;
            font-weight: 600;
            color: #1f2937;
        }
        
        .chart-header i {
            color: #22c55e;
            font-size: 20px;
        }
        
        .activity-card {
            background: white;
            border-radius: 15px;
            padding: 25px;
            box-shadow: 0 4px 15px rgba(0,0,0,0.05);
        }
        
        .activity-item {
            display: flex;
            align-items: center;
            gap: 15px;
            padding: 15px 0;
            border-bottom: 1px solid #f3f4f6;
        }
        
        .activity-item:last-child {
            border-bottom: none;
        }
        
        .activity-icon {
            width: 40px;
            height: 40px;
            border-radius: 10px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 16px;
        }
        
        .activity-icon.hadir {
            background: #d1fae5;
            color: #065f46;
        }
        
        .activity-icon.izin {
            background: #dbeafe;
            color: #1e40af;
        }
        
        .activity-icon.sakit {
            background: #fef3c7;
            color: #92400e;
        }
        
        .activity-icon.alpha {
            background: #fee2e2;
            color: #991b1b;
        }
        
        .activity-info {
            flex: 1;
        }
        
        .activity-info .name {
            font-size: 14px;
            font-weight: 600;
            color: #1f2937;
            margin-bottom: 3px;
        }
        
        .activity-info .details {
            font-size: 12px;
            color: #6b7280;
        }
        
        .activity-time {
            font-size: 11px;
            color: #9ca3af;
        }
        
        @media (max-width: 768px) {
            .sidebar {
                width: 75px;
            }
            
            .sidebar-logo-text,
            .sidebar-user,
            .menu-title,
            .menu-item span,
            .btn-logout span {
                display: none;
            }
            
            .sidebar-header {
                padding: 25px 12px;
            }
            
            .sidebar-logo {
                justify-content: center;
            }
            
            .sidebar-logo img {
                width: 45px;
                height: 45px;
            }
            
            .menu-item {
                justify-content: center;
                margin: 8px;
                padding: 16px 0;
            }
            
            .menu-item.active::before {
                left: -8px;
                height: 100%;
            }
            
            .menu-item i {
                width: auto;
                font-size: 22px;
            }
            
            .btn-logout {
                padding: 16px 10px;
                justify-content: center;
            }
            
            .main-content {
                margin-left: 75px;
                padding: 20px;
            }
            
            .stats-grid {
                grid-template-columns: 1fr;
            }
        }
    </style>
</head>
<body>
    <!-- Sidebar -->
    <div class="sidebar">
        <div class="sidebar-header">
            <div class="sidebar-logo">
                <img src="../logo.png" alt="Logo">
                <div class="sidebar-logo-text">
                    <h1>SIPANCUR</h1>
                    <p>SMAN 1 AJIBARANG</p>
                </div>
            </div>
        </div>
        
        <div class="sidebar-user">
            <div class="user-info">
                <div class="user-avatar">A</div>
                <div class="user-details">
                    <h3>Administrator</h3>
                    <p>Super Admin</p>
                </div>
            </div>
        </div>
        
        <div class="sidebar-menu">
            <div class="menu-section">
                <div class="menu-title">Menu Utama</div>
                <a href="dashboard.php" class="menu-item active">
                    <i class="fas fa-home"></i>
                    <span>Dashboard</span>
                </a>
                <a href="guru.php" class="menu-item">
                    <i class="fas fa-users"></i>
                    <span>Kelola Guru</span>
                </a>
                <a href="siswa.php" class="menu-item">
                    <i class="fas fa-user-graduate"></i>
                    <span>Data Siswa</span>
                </a>
                <a href="reporting.php" class="menu-item">
                    <i class="fas fa-chart-bar"></i>
                    <span>Reporting</span>
                </a>
                <a href="statistik.php" class="menu-item">
                    <i class="fas fa-chart-pie"></i>
                    <span>Statistik</span>
                </a>
                <a href="pengaturan.php" class="menu-item">
                    <i class="fas fa-cog"></i>
                    <span>Pengaturan</span>
                </a>
            </div>
        </div>
        
        <div class="sidebar-footer">
            <a href="../logout.php" class="btn-logout">
                <i class="fas fa-sign-out-alt"></i>
                <span>Keluar</span>
            </a>
        </div>
    </div>
    
    <!-- Main Content -->
    <div class="main-content">
        <div class="page-header">
            <h2>Dashboard Admin</h2>
            <p>Selamat datang di panel administrator SIPANCUR</p>
        </div>
        
        <!-- Stats Grid -->
        <div class="stats-grid">
            <div class="stat-card green">
                <div class="stat-header">
                    <div class="stat-icon"><i class="fas fa-chalkboard-teacher"></i></div>
                </div>
                <div class="stat-label">Total Guru Aktif</div>
                <div class="stat-value"><?php echo $total_guru; ?></div>
            </div>
            
            <div class="stat-card blue">
                <div class="stat-header">
                    <div class="stat-icon"><i class="fas fa-user-graduate"></i></div>
                </div>
                <div class="stat-label">Total Siswa Aktif</div>
                <div class="stat-value"><?php echo $total_siswa; ?></div>
            </div>
            
            <div class="stat-card yellow">
                <div class="stat-header">
                    <div class="stat-icon"><i class="fas fa-check-circle"></i></div>
                </div>
                <div class="stat-label">Hadir Hari Ini</div>
                <div class="stat-value"><?php echo $total_hadir; ?></div>
            </div>
            
            <div class="stat-card red">
                <div class="stat-header">
                    <div class="stat-icon"><i class="fas fa-times-circle"></i></div>
                </div>
                <div class="stat-label">Alpha Hari Ini</div>
                <div class="stat-value"><?php echo $total_alpha; ?></div>
            </div>
        </div>
        
        <!-- Chart Card -->
        <div class="chart-card">
            <div class="chart-header">
                <i class="fas fa-chart-line"></i>
                <h3>Grafik Absensi 7 Hari Terakhir</h3>
            </div>
            <canvas id="attendanceChart"></canvas>
        </div>
        
        <!-- Activity Card -->
        <div class="activity-card">
            <div class="chart-header">
                <i class="fas fa-history"></i>
                <h3>Aktivitas Terbaru</h3>
            </div>
            <?php if (count($recent_activities) > 0): ?>
                <?php foreach ($recent_activities as $activity): ?>
                    <div class="activity-item">
                        <div class="activity-icon <?php echo $activity['status']; ?>">
                            <i class="fas fa-<?php 
                                echo $activity['status'] == 'hadir' ? 'check' : 
                                    ($activity['status'] == 'izin' ? 'envelope' : 
                                    ($activity['status'] == 'sakit' ? 'medkit' : 'times')); 
                            ?>"></i>
                        </div>
                        <div class="activity-info">
                            <div class="name"><?php echo $activity['siswa_nama']; ?></div>
                            <div class="details"><?php echo ucfirst($activity['status']); ?> - <?php echo $activity['guru_nama']; ?> - <?php echo date('d M Y', strtotime($activity['tanggal'])); ?></div>
                        </div>
                        <div class="activity-time"><?php echo date('H:i', strtotime($activity['created_at'])); ?></div>
                    </div>
                <?php endforeach; ?>
            <?php else: ?>
                <div style="text-align: center; padding: 40px; color: #9ca3af;">
                    <i class="fas fa-inbox" style="font-size: 48px; margin-bottom: 10px;"></i>
                    <p>Belum ada aktivitas</p>
                </div>
            <?php endif; ?>
        </div>
    </div>
    
    <script>
        const ctx = document.getElementById('attendanceChart').getContext('2d');
        const chartData = <?php echo json_encode($chart_data); ?>;
        
        new Chart(ctx, {
            type: 'line',
            data: {
                labels: chartData.map(d => d.date),
                datasets: [
                    {
                        label: 'Hadir',
                        data: chartData.map(d => d.hadir),
                        borderColor: '#22c55e',
                        backgroundColor: 'rgba(74, 222, 128, 0.1)',
                        tension: 0.4,
                        fill: true
                    },
                    {
                        label: 'Izin',
                        data: chartData.map(d => d.izin),
                        borderColor: '#3b82f6',
                        backgroundColor: 'rgba(59, 130, 246, 0.1)',
                        tension: 0.4,
                        fill: true
                    },
                    {
                        label: 'Sakit',
                        data: chartData.map(d => d.sakit),
                        borderColor: '#eab308',
                        backgroundColor: 'rgba(234, 179, 8, 0.1)',
                        tension: 0.4,
                        fill: true
                    },
                    {
                        label: 'Alpha',
                        data: chartData.map(d => d.alpha),
                        borderColor: '#ef4444',
                        backgroundColor: 'rgba(239, 68, 68, 0.1)',
                        tension: 0.4,
                        fill: true
                    }
                ]
            },
            options: {
                responsive: true,
                maintainAspectRatio: true,
                plugins: {
                    legend: {
                        position: 'top',
                        labels: {
                            font: {
                                family: 'Poppins',
                                size: 12
                            },
                            usePointStyle: true,
                            padding: 15
                        }
                    }
                },
                scales: {
                    y: {
                        beginAtZero: true,
                        ticks: {
                            font: {
                                family: 'Poppins'
                            }
                        }
                    },
                    x: {
                        ticks: {
                            font: {
                                family: 'Poppins'
                            }
                        }
                    }
                }
            }
        });
    </script>
</body>
</html>
