<?php
session_start();
if (!isset($_SESSION['admin_id'])) {
    header('Location: ../login.php');
    exit();
}

require_once '../config/database.php';
$conn = getConnection();

// Get filter
$filter = $_GET['filter'] ?? 'harian';
$tanggal = $_GET['tanggal'] ?? date('Y-m-d');
$bulan = $_GET['bulan'] ?? date('Y-m');
$guru_id = $_GET['guru_id'] ?? '';

// Prepare query based on filter
if ($filter == 'harian') {
    $where = "WHERE DATE(a.tanggal) = '$tanggal'";
    $filename = "Laporan_Harian_" . date('d-m-Y', strtotime($tanggal));
} elseif ($filter == 'mingguan') {
    $start_week = date('Y-m-d', strtotime('monday this week', strtotime($tanggal)));
    $end_week = date('Y-m-d', strtotime('sunday this week', strtotime($tanggal)));
    $where = "WHERE a.tanggal BETWEEN '$start_week' AND '$end_week'";
    $filename = "Laporan_Mingguan_" . date('d-m-Y', strtotime($start_week));
} else { // bulanan
    $start_month = $bulan . '-01';
    $end_month = date('Y-m-t', strtotime($start_month));
    $where = "WHERE a.tanggal BETWEEN '$start_month' AND '$end_month'";
    $filename = "Laporan_Bulanan_" . date('M-Y', strtotime($start_month));
}

if ($guru_id) {
    $where .= " AND a.guru_id = $guru_id";
    $guru_detail = $conn->query("SELECT nama FROM guru WHERE id=$guru_id")->fetch_assoc();
    $filename .= "_" . str_replace(' ', '_', $guru_detail['nama']);
}

// Get summary statistics
$stats = $conn->query("
    SELECT 
        SUM(CASE WHEN a.status='Hadir' THEN 1 ELSE 0 END) as total_hadir,
        SUM(CASE WHEN a.status='Izin' THEN 1 ELSE 0 END) as total_izin,
        SUM(CASE WHEN a.status='Sakit' THEN 1 ELSE 0 END) as total_sakit,
        SUM(CASE WHEN a.status='Alpha' THEN 1 ELSE 0 END) as total_alpha
    FROM absensi a
    $where
")->fetch_assoc();

// Get detailed data
$detail_data = $conn->query("
    SELECT 
        s.nama as siswa_nama,
        s.nis,
        s.kelas,
        g.nama as guru_nama,
        a.tanggal,
        a.status,
        a.keterangan
    FROM absensi a
    JOIN siswa s ON a.siswa_id = s.id
    JOIN guru g ON a.guru_id = g.id
    $where
    ORDER BY a.tanggal DESC, s.nama ASC
")->fetch_all(MYSQLI_ASSOC);

$conn->close();

// Set header for Excel
header("Content-Type: application/vnd.ms-excel");
header("Content-Disposition: attachment; filename=\"{$filename}.xls\"");
header("Pragma: no-cache");
header("Expires: 0");
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Laporan Presensi</title>
    <style>
        table {
            border-collapse: collapse;
            width: 100%;
        }
        
        th, td {
            border: 1px solid #000;
            padding: 8px;
            text-align: left;
        }
        
        th {
            background-color: #22c55e;
            color: white;
            font-weight: bold;
        }
        
        .header-section {
            margin-bottom: 20px;
        }
        
        .logo-text {
            font-size: 18pt;
            font-weight: bold;
            color: #22c55e;
        }
        
        .title {
            font-size: 14pt;
            font-weight: bold;
            text-align: center;
            margin: 15px 0;
        }
        
        .info-table {
            margin-bottom: 20px;
        }
        
        .info-table td {
            border: none;
            padding: 4px;
        }
        
        .stats-table {
            margin-bottom: 20px;
        }
        
        .stats-table th {
            background-color: #4ade80;
        }
        
        .center {
            text-align: center;
        }
    </style>
</head>
<body>
    <div class="header-section">
        <h1 class="logo-text">SIPANCUR MOBILE</h1>
        <h2>SMAN 1 AJIBARANG</h2>
        <p>Sistem Informasi Presensi Sekolah</p>
    </div>
    
    <h2 class="title">
        LAPORAN PRESENSI 
        <?php 
        if ($filter == 'harian') echo 'HARIAN';
        elseif ($filter == 'mingguan') echo 'MINGGUAN';
        else echo 'BULANAN';
        ?>
    </h2>
    
    <table class="info-table">
        <tr>
            <td width="150"><strong>Periode</strong></td>
            <td>:</td>
            <td>
                <?php 
                if ($filter == 'harian') {
                    echo date('d F Y', strtotime($tanggal));
                } elseif ($filter == 'mingguan') {
                    echo date('d M', strtotime($start_week)) . " s/d " . date('d M Y', strtotime($end_week));
                } else {
                    echo date('F Y', strtotime($start_month));
                }
                ?>
            </td>
        </tr>
        <?php if (isset($guru_detail)): ?>
        <tr>
            <td><strong>Guru</strong></td>
            <td>:</td>
            <td><?php echo $guru_detail['nama']; ?></td>
        </tr>
        <?php endif; ?>
        <tr>
            <td><strong>Tanggal Cetak</strong></td>
            <td>:</td>
            <td><?php echo date('d F Y, H:i'); ?> WIB</td>
        </tr>
        <tr>
            <td><strong>Dicetak Oleh</strong></td>
            <td>:</td>
            <td>Administrator</td>
        </tr>
    </table>
    
    <h3>RINGKASAN KEHADIRAN</h3>
    <table class="stats-table">
        <thead>
            <tr>
                <th class="center">Hadir</th>
                <th class="center">Izin</th>
                <th class="center">Sakit</th>
                <th class="center">Alpha</th>
                <th class="center">Total</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td class="center"><?php echo $stats['total_hadir'] ?? 0; ?></td>
                <td class="center"><?php echo $stats['total_izin'] ?? 0; ?></td>
                <td class="center"><?php echo $stats['total_sakit'] ?? 0; ?></td>
                <td class="center"><?php echo $stats['total_alpha'] ?? 0; ?></td>
                <td class="center">
                    <?php 
                    echo ($stats['total_hadir'] ?? 0) + 
                         ($stats['total_izin'] ?? 0) + 
                         ($stats['total_sakit'] ?? 0) + 
                         ($stats['total_alpha'] ?? 0); 
                    ?>
                </td>
            </tr>
        </tbody>
    </table>
    
    <h3>DATA DETAIL PRESENSI</h3>
    <?php if (count($detail_data) > 0): ?>
    <table>
        <thead>
            <tr>
                <th width="5%">No</th>
                <th width="22%">Nama Siswa</th>
                <th width="10%">NIS</th>
                <th width="8%">Kelas</th>
                <th width="15%">Guru</th>
                <th width="10%">Tanggal</th>
                <th width="10%">Status</th>
                <th>Keterangan</th>
            </tr>
        </thead>
        <tbody>
            <?php $no = 1; foreach ($detail_data as $row): ?>
            <tr>
                <td class="center"><?php echo $no++; ?></td>
                <td><?php echo $row['siswa_nama']; ?></td>
                <td><?php echo $row['nis']; ?></td>
                <td><?php echo $row['kelas']; ?></td>
                <td><?php echo $row['guru_nama']; ?></td>
                <td><?php echo date('d/m/Y', strtotime($row['tanggal'])); ?></td>
                <td><?php echo ucfirst($row['status']); ?></td>
                <td><?php echo $row['keterangan'] ?: '-'; ?></td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <?php else: ?>
    <p style="text-align: center; padding: 20px;">Tidak ada data presensi</p>
    <?php endif; ?>
    
    <br><br>
    <table class="info-table">
        <tr>
            <td width="50%"></td>
            <td style="text-align: center;">
                <?php echo date('d F Y'); ?><br>
                Administrator<br><br><br><br>
                <strong>(...........................)</strong>
            </td>
        </tr>
    </table>
    
    <p style="font-size: 8pt; color: #666; margin-top: 30px; border-top: 1px solid #ccc; padding-top: 10px;">
        Dokumen ini dicetak secara otomatis oleh SIPANCUR MOBILE pada <?php echo date('d F Y, H:i:s'); ?> WIB
    </p>
</body>
</html>
