<?php
session_start();
if (!isset($_SESSION['admin_id'])) {
    header('Location: ../login.php');
    exit();
}

require_once '../config/database.php';
$conn = getConnection();

// Get filter
$filter = $_GET['filter'] ?? 'harian';
$tanggal = $_GET['tanggal'] ?? date('Y-m-d');
$bulan = $_GET['bulan'] ?? date('Y-m');
$guru_id = $_GET['guru_id'] ?? '';

// Prepare query based on filter
if ($filter == 'harian') {
    $where = "WHERE DATE(a.tanggal) = '$tanggal'";
    $title = "LAPORAN PRESENSI HARIAN";
    $subtitle = date('d F Y', strtotime($tanggal));
} elseif ($filter == 'mingguan') {
    $start_week = date('Y-m-d', strtotime('monday this week', strtotime($tanggal)));
    $end_week = date('Y-m-d', strtotime('sunday this week', strtotime($tanggal)));
    $where = "WHERE a.tanggal BETWEEN '$start_week' AND '$end_week'";
    $title = "LAPORAN PRESENSI MINGGUAN";
    $subtitle = date('d M', strtotime($start_week)) . " s/d " . date('d M Y', strtotime($end_week));
} else { // bulanan
    $start_month = $bulan . '-01';
    $end_month = date('Y-m-t', strtotime($start_month));
    $where = "WHERE a.tanggal BETWEEN '$start_month' AND '$end_month'";
    $title = "LAPORAN PRESENSI BULANAN";
    $subtitle = date('F Y', strtotime($start_month));
}

if ($guru_id) {
    $where .= " AND a.guru_id = $guru_id";
    $guru_detail = $conn->query("SELECT nama FROM guru WHERE id=$guru_id")->fetch_assoc();
}

// Get summary statistics
$stats = $conn->query("
    SELECT 
        SUM(CASE WHEN a.status='Hadir' THEN 1 ELSE 0 END) as total_hadir,
        SUM(CASE WHEN a.status='Izin' THEN 1 ELSE 0 END) as total_izin,
        SUM(CASE WHEN a.status='Sakit' THEN 1 ELSE 0 END) as total_sakit,
        SUM(CASE WHEN a.status='Alpha' THEN 1 ELSE 0 END) as total_alpha
    FROM absensi a
    $where
")->fetch_assoc();

$total_all = ($stats['total_hadir'] ?? 0) + ($stats['total_izin'] ?? 0) + ($stats['total_sakit'] ?? 0) + ($stats['total_alpha'] ?? 0);
$persentase_hadir = $total_all > 0 ? round(($stats['total_hadir'] / $total_all) * 100, 1) : 0;

// Get detailed data
$detail_data = $conn->query("
    SELECT 
        s.nama as siswa_nama,
        s.nis,
        s.kelas,
        g.nama as guru_nama,
        a.tanggal,
        a.status,
        a.keterangan
    FROM absensi a
    JOIN siswa s ON a.siswa_id = s.id
    JOIN guru g ON a.guru_id = g.id
    $where
    ORDER BY a.tanggal DESC, s.nama ASC
")->fetch_all(MYSQLI_ASSOC);

$conn->close();

// Set header for PDF
header('Content-Type: text/html; charset=utf-8');
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title><?php echo $title; ?></title>
    <style>
        @page {
            size: A4;
            margin: 15mm;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: Arial, sans-serif;
            font-size: 11pt;
            line-height: 1.4;
            color: #000;
        }
        
        .header-section {
            border-bottom: 3px solid #22c55e;
            padding-bottom: 15px;
            margin-bottom: 20px;
            display: flex;
            align-items: center;
            gap: 15px;
        }
        
        .logo {
            width: 80px;
            height: 80px;
            border-radius: 15px;
            flex-shrink: 0;
            overflow: hidden;
            border: 2px solid #22c55e;
        }
        
        .header-text {
            flex: 1;
        }
        
        .header-text h1 {
            font-size: 18pt;
            font-weight: bold;
            color: #1f2937;
            margin-bottom: 3px;
        }
        
        .header-text h2 {
            font-size: 14pt;
            font-weight: normal;
            color: #22c55e;
            margin-bottom: 5px;
        }
        
        .header-text p {
            font-size: 9pt;
            color: #6b7280;
        }
        
        .report-title {
            text-align: center;
            margin: 25px 0 20px;
        }
        
        .report-title h3 {
            font-size: 14pt;
            font-weight: bold;
            color: #1f2937;
            margin-bottom: 5px;
            text-transform: uppercase;
        }
        
        .report-title p {
            font-size: 11pt;
            color: #6b7280;
        }
        
        .info-box {
            background: #f9fafb;
            border: 1px solid #e5e7eb;
            border-radius: 8px;
            padding: 12px 15px;
            margin-bottom: 20px;
        }
        
        .info-box table {
            width: 100%;
            font-size: 10pt;
        }
        
        .info-box td {
            padding: 3px 0;
        }
        
        .info-box td:first-child {
            width: 150px;
            color: #6b7280;
        }
        
        .info-box td:nth-child(2) {
            width: 10px;
            text-align: center;
        }
        
        .info-box td:last-child {
            font-weight: 600;
            color: #1f2937;
        }
        
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(4, 1fr);
            gap: 10px;
            margin-bottom: 25px;
        }
        
        .stat-card {
            border: 1px solid #e5e7eb;
            border-radius: 8px;
            padding: 12px;
            text-align: center;
        }
        
        .stat-card.hadir {
            background: #d1fae5;
            border-color: #22c55e;
        }
        
        .stat-card.izin {
            background: #dbeafe;
            border-color: #3b82f6;
        }
        
        .stat-card.sakit {
            background: #fef3c7;
            border-color: #eab308;
        }
        
        .stat-card.alpha {
            background: #fee2e2;
            border-color: #ef4444;
        }
        
        .stat-card .label {
            font-size: 9pt;
            color: #6b7280;
            margin-bottom: 5px;
            text-transform: uppercase;
            font-weight: 600;
        }
        
        .stat-card .value {
            font-size: 24pt;
            font-weight: bold;
        }
        
        .stat-card.hadir .value {
            color: #065f46;
        }
        
        .stat-card.izin .value {
            color: #1e40af;
        }
        
        .stat-card.sakit .value {
            color: #92400e;
        }
        
        .stat-card.alpha .value {
            color: #991b1b;
        }
        
        .persentase-box {
            background: linear-gradient(135deg, #4ade80 0%, #22c55e 100%);
            color: white;
            padding: 15px;
            border-radius: 8px;
            text-align: center;
            margin-bottom: 25px;
        }
        
        .persentase-box .label {
            font-size: 10pt;
            margin-bottom: 5px;
        }
        
        .persentase-box .value {
            font-size: 32pt;
            font-weight: bold;
        }
        
        table.data-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
            font-size: 9pt;
        }
        
        table.data-table thead {
            background: #22c55e;
            color: white;
        }
        
        table.data-table th {
            padding: 10px 8px;
            text-align: left;
            font-weight: 600;
        }
        
        table.data-table td {
            padding: 8px;
            border-bottom: 1px solid #e5e7eb;
        }
        
        table.data-table tbody tr:hover {
            background: #f9fafb;
        }
        
        .status-badge {
            display: inline-block;
            padding: 4px 10px;
            border-radius: 12px;
            font-size: 8pt;
            font-weight: 600;
        }
        
        .status-badge.hadir {
            background: #d1fae5;
            color: #065f46;
        }
        
        .status-badge.izin {
            background: #dbeafe;
            color: #1e40af;
        }
        
        .status-badge.sakit {
            background: #fef3c7;
            color: #92400e;
        }
        
        .status-badge.alpha {
            background: #fee2e2;
            color: #991b1b;
        }
        
        .footer-section {
            margin-top: 40px;
            display: flex;
            justify-content: space-between;
        }
        
        .signature-box {
            width: 200px;
            text-align: center;
        }
        
        .signature-box p {
            font-size: 9pt;
            margin-bottom: 60px;
        }
        
        .signature-box .name {
            font-weight: bold;
            border-top: 1px solid #000;
            padding-top: 5px;
            display: inline-block;
            min-width: 150px;
        }
        
        .print-info {
            font-size: 8pt;
            color: #9ca3af;
            text-align: center;
            margin-top: 30px;
            padding-top: 15px;
            border-top: 1px solid #e5e7eb;
        }
        
        @media print {
            .no-print {
                display: none !important;
            }
            
            body {
                print-color-adjust: exact;
                -webkit-print-color-adjust: exact;
            }
        }
        
        .btn-container {
            position: fixed;
            top: 20px;
            right: 20px;
            display: flex;
            gap: 10px;
            z-index: 1000;
        }
        
        .btn {
            padding: 12px 24px;
            border: none;
            border-radius: 8px;
            font-size: 14px;
            font-weight: 600;
            cursor: pointer;
            display: flex;
            align-items: center;
            gap: 8px;
            text-decoration: none;
        }
        
        .btn-print {
            background: #22c55e;
            color: white;
        }
        
        .btn-back {
            background: #6b7280;
            color: white;
        }
    </style>
</head>
<body>
    <div class="btn-container no-print">
        <button onclick="window.print()" class="btn btn-print">
            <i class="fas fa-print"></i> Cetak PDF
        </button>
        <a href="reporting.php<?php echo isset($_SERVER['QUERY_STRING']) ? '?' . $_SERVER['QUERY_STRING'] : ''; ?>" class="btn btn-back">
            <i class="fas fa-arrow-left"></i> Kembali
        </a>
    </div>

    <div class="header-section">
        <div class="logo">
            <img src="../logo.png" alt="Logo" style="width: 100%; height: 100%; object-fit: contain; border-radius: 15px;">
        </div>
        <div class="header-text">
            <h1>SIPANCUR MOBILE</h1>
            <h2>SMAN 1 AJIBARANG</h2>
            <p>Sistem Informasi Presensi Sekolah</p>
        </div>
    </div>
    
    <div class="report-title">
        <h3><?php echo $title; ?></h3>
        <p><?php echo $subtitle; ?></p>
    </div>
    
    <div class="info-box">
        <table>
            <?php if (isset($guru_detail)): ?>
            <tr>
                <td>Guru</td>
                <td>:</td>
                <td><?php echo $guru_detail['nama']; ?></td>
            </tr>
            <?php endif; ?>
            <tr>
                <td>Tanggal Cetak</td>
                <td>:</td>
                <td><?php echo date('d F Y, H:i'); ?> WIB</td>
            </tr>
            <tr>
                <td>Dicetak Oleh</td>
                <td>:</td>
                <td>Administrator</td>
            </tr>
        </table>
    </div>
    
    <div class="stats-grid">
        <div class="stat-card hadir">
            <div class="label">Hadir</div>
            <div class="value"><?php echo $stats['total_hadir'] ?? 0; ?></div>
        </div>
        <div class="stat-card izin">
            <div class="label">Izin</div>
            <div class="value"><?php echo $stats['total_izin'] ?? 0; ?></div>
        </div>
        <div class="stat-card sakit">
            <div class="label">Sakit</div>
            <div class="value"><?php echo $stats['total_sakit'] ?? 0; ?></div>
        </div>
        <div class="stat-card alpha">
            <div class="label">Alpha</div>
            <div class="value"><?php echo $stats['total_alpha'] ?? 0; ?></div>
        </div>
    </div>
    
    <div class="persentase-box">
        <div class="label">Persentase Kehadiran</div>
        <div class="value"><?php echo $persentase_hadir; ?>%</div>
    </div>
    
    <?php if (count($detail_data) > 0): ?>
    <table class="data-table">
        <thead>
            <tr>
                <th width="5%">No</th>
                <th width="22%">Nama Siswa</th>
                <th width="10%">NIS</th>
                <th width="8%">Kelas</th>
                <th width="15%">Guru</th>
                <th width="10%">Tanggal</th>
                <th width="10%">Status</th>
                <th>Keterangan</th>
            </tr>
        </thead>
        <tbody>
            <?php $no = 1; foreach ($detail_data as $row): ?>
            <tr>
                <td><?php echo $no++; ?></td>
                <td><?php echo $row['siswa_nama']; ?></td>
                <td><?php echo $row['nis']; ?></td>
                <td><?php echo $row['kelas']; ?></td>
                <td><?php echo $row['guru_nama']; ?></td>
                <td><?php echo date('d/m/Y', strtotime($row['tanggal'])); ?></td>
                <td>
                    <span class="status-badge <?php echo strtolower($row['status']); ?>">
                        <?php echo ucfirst($row['status']); ?>
                    </span>
                </td>
                <td><?php echo $row['keterangan'] ?: '-'; ?></td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <?php else: ?>
    <p style="text-align: center; padding: 30px; color: #6b7280;">Tidak ada data presensi</p>
    <?php endif; ?>
    
    <div class="footer-section">
        <div class="signature-box">
            <p>Mengetahui,<br>Kepala Sekolah</p>
            <div class="name">(...........................)</div>
        </div>
        <div class="signature-box">
            <p><?php echo date('d F Y'); ?><br>Administrator</p>
            <div class="name">(...........................)</div>
        </div>
    </div>
    
    <div class="print-info">
        Dokumen ini dicetak secara otomatis oleh SIPANCUR MOBILE pada <?php echo date('d F Y, H:i:s'); ?> WIB
    </div>
</body>
</html>
