<?php
session_start();
if (!isset($_SESSION['admin_id'])) {
    header('Location: ../login.php');
    exit();
}

require_once '../config/database.php';
$conn = getConnection();

// Handle actions
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (isset($_POST['action'])) {
        if ($_POST['action'] == 'add') {
            $nip = $_POST['nip'];
            $username = $_POST['username'];
            $password = password_hash($_POST['password'], PASSWORD_DEFAULT);
            $nama = $_POST['nama'];
            $email = $_POST['email'];
            $telepon = $_POST['telepon'];
            $alamat = $_POST['alamat'];
            
            $stmt = $conn->prepare("INSERT INTO guru (nip, username, password, nama, email, telepon, alamat) VALUES (?, ?, ?, ?, ?, ?, ?)");
            $stmt->bind_param("sssssss", $nip, $username, $password, $nama, $email, $telepon, $alamat);
            
            if ($stmt->execute()) {
                $success = "Guru berhasil ditambahkan!";
            } else {
                $error = "Gagal menambahkan guru: " . $stmt->error;
            }
            $stmt->close();
        } elseif ($_POST['action'] == 'edit') {
            $id = $_POST['id'];
            $nip = $_POST['nip'];
            $username = $_POST['username'];
            $nama = $_POST['nama'];
            $email = $_POST['email'];
            $telepon = $_POST['telepon'];
            $alamat = $_POST['alamat'];
            $status = $_POST['status'];
            
            if (!empty($_POST['password'])) {
                $password = password_hash($_POST['password'], PASSWORD_DEFAULT);
                $stmt = $conn->prepare("UPDATE guru SET nip=?, username=?, password=?, nama=?, email=?, telepon=?, alamat=?, status=? WHERE id=?");
                $stmt->bind_param("ssssssssi", $nip, $username, $password, $nama, $email, $telepon, $alamat, $status, $id);
            } else {
                $stmt = $conn->prepare("UPDATE guru SET nip=?, username=?, nama=?, email=?, telepon=?, alamat=?, status=? WHERE id=?");
                $stmt->bind_param("sssssssi", $nip, $username, $nama, $email, $telepon, $alamat, $status, $id);
            }
            
            if ($stmt->execute()) {
                $success = "Data guru berhasil diupdate!";
            } else {
                $error = "Gagal mengupdate guru: " . $stmt->error;
            }
            $stmt->close();
        } elseif ($_POST['action'] == 'delete') {
            $id = $_POST['id'];
            $stmt = $conn->prepare("DELETE FROM guru WHERE id=?");
            $stmt->bind_param("i", $id);
            
            if ($stmt->execute()) {
                $success = "Guru berhasil dihapus!";
            } else {
                $error = "Gagal menghapus guru: " . $stmt->error;
            }
            $stmt->close();
        }
    }
}

// Get all guru
$guru_list = $conn->query("SELECT * FROM guru ORDER BY created_at DESC")->fetch_all(MYSQLI_ASSOC);

$conn->close();
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Kelola Guru - SIPANCUR MOBILE</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Poppins', sans-serif;
            background: #f3f4f6;
            display: flex;
            min-height: 100vh;
        }
        
        /* Sidebar */
        .sidebar {
            width: 280px;
            background: white;
            box-shadow: 2px 0 10px rgba(0,0,0,0.08);
            position: fixed;
            left: 0;
            top: 0;
            bottom: 0;
            z-index: 1000;
            display: flex;
            flex-direction: column;
        }
        
        .sidebar-header {
            padding: 30px 25px;
            background: linear-gradient(135deg, #4ade80 0%, #22c55e 100%);
            color: white;
        }
        
        .sidebar-logo {
            display: flex;
            align-items: center;
            gap: 15px;
        }
        
        .sidebar-logo img {
            width: 50px;
            height: 50px;
            border-radius: 12px;
            border: 2px solid rgba(255,255,255,0.3);
            box-shadow: 0 4px 10px rgba(0,0,0,0.1);
        }
        
        .sidebar-logo-text h1 {
            font-size: 20px;
            font-weight: 700;
            margin-bottom: 2px;
        }
        
        .sidebar-logo-text p {
            font-size: 11px;
            opacity: 0.9;
            font-weight: 400;
        }
        
        .sidebar-user {
            padding: 25px;
            border-bottom: 1px solid #e5e7eb;
            background: #f9fafb;
        }
        
        .user-info {
            display: flex;
            align-items: center;
            gap: 15px;
        }
        
        .user-avatar {
            width: 50px;
            height: 50px;
            background: linear-gradient(135deg, #4ade80 0%, #22c55e 100%);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 20px;
            font-weight: 700;
            box-shadow: 0 4px 12px rgba(74, 222, 128, 0.3);
            flex-shrink: 0;
        }
        
        .user-details {
            flex: 1;
            min-width: 0;
        }
        
        .user-details h3 {
            font-size: 15px;
            font-weight: 600;
            color: #1f2937;
            margin: 0 0 3px 0;
            line-height: 1.2;
        }
        
        .user-details p {
            font-size: 12px;
            color: #6b7280;
            font-weight: 500;
            margin: 0;
            line-height: 1.2;
        }
        
        .sidebar-menu {
            flex: 1;
            padding: 25px 0;
            overflow-y: auto;
        }
        
        .menu-section {
            margin-bottom: 30px;
        }
        
        .menu-title {
            padding: 0 25px;
            font-size: 11px;
            font-weight: 700;
            color: #9ca3af;
            text-transform: uppercase;
            letter-spacing: 1px;
            margin-bottom: 10px;
        }
        
        .menu-item {
            display: flex;
            align-items: center;
            gap: 15px;
            padding: 14px 25px;
            margin: 0 15px;
            color: #6b7280;
            text-decoration: none;
            transition: all 0.3s;
            position: relative;
            border-radius: 10px;
        }
        
        .menu-item:hover {
            background: #f3f4f6;
            color: #22c55e;
        }
        
        .menu-item.active {
            background: linear-gradient(135deg, rgba(74, 222, 128, 0.15) 0%, rgba(34, 197, 94, 0.15) 100%);
            color: #22c55e;
            font-weight: 600;
        }
        
        .menu-item.active::before {
            content: '';
            position: absolute;
            left: -15px;
            top: 50%;
            transform: translateY(-50%);
            width: 4px;
            height: 70%;
            background: #22c55e;
            border-radius: 0 4px 4px 0;
        }
        
        .menu-item i {
            width: 22px;
            font-size: 20px;
            text-align: center;
        }
        
        .menu-item span {
            font-size: 14px;
            font-weight: 500;
        }
        
        .sidebar-footer {
            padding: 25px;
            border-top: 1px solid #e5e7eb;
            background: #f9fafb;
        }
        
        .btn-logout {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 10px;
            width: 100%;
            padding: 14px;
            background: linear-gradient(135deg, #f87171 0%, #ef4444 100%);
            color: white;
            text-decoration: none;
            border-radius: 12px;
            font-size: 14px;
            font-weight: 600;
            transition: all 0.3s;
            box-shadow: 0 4px 12px rgba(239, 68, 68, 0.2);
        }
        
        .btn-logout:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(239, 68, 68, 0.3);
        }
        
        .btn-logout:active {
            transform: translateY(0);
        }
        
        /* Main Content */
        .main-content {
            margin-left: 280px;
            flex: 1;
            padding: 30px;
        }
        
        .page-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 30px;
        }
        
        .page-header h2 {
            font-size: 28px;
            font-weight: 700;
            color: #1f2937;
            display: flex;
            align-items: center;
            gap: 12px;
        }
        
        .btn-primary {
            background: linear-gradient(135deg, #4ade80 0%, #22c55e 100%);
            color: white;
            padding: 12px 24px;
            border: none;
            border-radius: 10px;
            cursor: pointer;
            font-size: 14px;
            font-weight: 600;
            display: inline-flex;
            align-items: center;
            gap: 8px;
            transition: all 0.3s;
        }
        
        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(74, 222, 128, 0.3);
        }
        
        .alert {
            padding: 15px 20px;
            border-radius: 10px;
            margin-bottom: 20px;
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        .alert.success {
            background: #d1fae5;
            color: #065f46;
        }
        
        .alert.error {
            background: #fee2e2;
            color: #991b1b;
        }
        
        .card {
            background: white;
            border-radius: 15px;
            padding: 25px;
            box-shadow: 0 4px 15px rgba(0,0,0,0.05);
        }
        
        .table-responsive {
            overflow-x: auto;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
        }
        
        table thead {
            background: #f9fafb;
        }
        
        table th {
            padding: 15px;
            text-align: left;
            color: #6b7280;
            font-weight: 600;
            font-size: 13px;
            text-transform: uppercase;
            border-bottom: 2px solid #e5e7eb;
        }
        
        table td {
            padding: 15px;
            color: #374151;
            border-bottom: 1px solid #f3f4f6;
        }
        
        table tbody tr:hover {
            background: #f9fafb;
        }
        
        .badge {
            padding: 5px 12px;
            border-radius: 20px;
            font-size: 12px;
            font-weight: 500;
        }
        
        .badge.success {
            background: #d1fae5;
            color: #065f46;
        }
        
        .badge.danger {
            background: #fee2e2;
            color: #991b1b;
        }
        
        .btn-action {
            padding: 8px 12px;
            border: none;
            border-radius: 6px;
            cursor: pointer;
            font-size: 12px;
            margin-right: 5px;
            transition: all 0.3s;
        }
        
        .btn-edit {
            background: #dbeafe;
            color: #1e40af;
        }
        
        .btn-edit:hover {
            background: #bfdbfe;
        }
        
        .btn-delete {
            background: #fee2e2;
            color: #991b1b;
        }
        
        .btn-delete:hover {
            background: #fecaca;
        }
        
        .modal {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0,0,0,0.5);
            z-index: 2000;
            overflow-y: auto;
            padding: 20px;
        }
        
        .modal.active {
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .modal-content {
            background: white;
            border-radius: 15px;
            padding: 30px;
            max-width: 600px;
            width: 100%;
            max-height: 90vh;
            overflow-y: auto;
        }
        
        .modal-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 25px;
        }
        
        .modal-header h3 {
            color: #1f2937;
            font-size: 20px;
            font-weight: 600;
        }
        
        .btn-close {
            background: #f3f4f6;
            border: none;
            width: 35px;
            height: 35px;
            border-radius: 8px;
            cursor: pointer;
            display: flex;
            align-items: center;
            justify-content: center;
            color: #6b7280;
            font-size: 18px;
        }
        
        .form-group {
            margin-bottom: 20px;
        }
        
        .form-group label {
            display: block;
            color: #374151;
            font-weight: 500;
            margin-bottom: 8px;
            font-size: 14px;
        }
        
        .form-group input,
        .form-group select,
        .form-group textarea {
            width: 100%;
            padding: 12px 15px;
            border: 2px solid #e5e7eb;
            border-radius: 8px;
            font-size: 14px;
            font-family: 'Poppins', sans-serif;
            transition: all 0.3s;
        }
        
        .form-group input:focus,
        .form-group select:focus,
        .form-group textarea:focus {
            outline: none;
            border-color: #4ade80;
            box-shadow: 0 0 0 3px rgba(74, 222, 128, 0.1);
        }
        
        .form-group textarea {
            resize: vertical;
            min-height: 80px;
        }
        
        .form-row {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 15px;
        }
        
        .modal-footer {
            display: flex;
            gap: 10px;
            justify-content: flex-end;
            margin-top: 25px;
        }
        
        .btn-secondary {
            background: #e5e7eb;
            color: #374151;
            padding: 12px 24px;
            border: none;
            border-radius: 8px;
            cursor: pointer;
            font-size: 14px;
            font-weight: 500;
            transition: all 0.3s;
        }
        
        .btn-secondary:hover {
            background: #d1d5db;
        }
        
        @media (max-width: 768px) {
            .sidebar {
                width: 75px;
            }
            
            .sidebar-logo-text,
            .sidebar-user,
            .menu-title,
            .menu-item span,
            .btn-logout span {
                display: none;
            }
            
            .sidebar-header {
                padding: 25px 12px;
            }
            
            .sidebar-logo {
                justify-content: center;
            }
            
            .sidebar-logo img {
                width: 45px;
                height: 45px;
            }
            
            .menu-item {
                justify-content: center;
                margin: 8px;
                padding: 16px 0;
            }
            
            .menu-item.active::before {
                left: -8px;
                height: 100%;
            }
            
            .menu-item i {
                width: auto;
                font-size: 22px;
            }
            
            .btn-logout {
                padding: 16px 10px;
                justify-content: center;
            }
            
            .main-content {
                margin-left: 75px;
                padding: 20px;
            }
            
            .page-header {
                flex-direction: column;
                gap: 15px;
                align-items: flex-start;
            }
            
            .form-row {
                grid-template-columns: 1fr;
            }
        }
    </style>
</head>
<body>
    <!-- Sidebar -->
    <div class="sidebar">
        <div class="sidebar-header">
            <div class="sidebar-logo">
                <img src="../logo.png" alt="Logo">
                <div class="sidebar-logo-text">
                    <h1>SIPANCUR</h1>
                    <p>SMAN 1 AJIBARANG</p>
                </div>
            </div>
        </div>
        
        <div class="sidebar-user">
            <div class="user-info">
                <div class="user-avatar">A</div>
                <div class="user-details">
                    <h3>Administrator</h3>
                    <p>Super Admin</p>
                </div>
            </div>
        </div>
        
        <div class="sidebar-menu">
            <div class="menu-section">
                <div class="menu-title">Menu Utama</div>
                <a href="dashboard.php" class="menu-item">
                    <i class="fas fa-home"></i>
                    <span>Dashboard</span>
                </a>
                <a href="guru.php" class="menu-item active">
                    <i class="fas fa-users"></i>
                    <span>Kelola Guru</span>
                </a>
                <a href="siswa.php" class="menu-item">
                    <i class="fas fa-user-graduate"></i>
                    <span>Data Siswa</span>
                </a>
                <a href="reporting.php" class="menu-item">
                    <i class="fas fa-chart-bar"></i>
                    <span>Reporting</span>
                </a>
                <a href="statistik.php" class="menu-item">
                    <i class="fas fa-chart-pie"></i>
                    <span>Statistik</span>
                </a>
                <a href="pengaturan.php" class="menu-item">
                    <i class="fas fa-cog"></i>
                    <span>Pengaturan</span>
                </a>
            </div>
        </div>
        
        <div class="sidebar-footer">
            <a href="../logout.php" class="btn-logout">
                <i class="fas fa-sign-out-alt"></i>
                <span>Keluar</span>
            </a>
        </div>
    </div>
    
    <!-- Main Content -->
    <div class="main-content">
        <?php if (isset($success)): ?>
        <div class="alert success">
            <i class="fas fa-check-circle"></i>
            <span><?php echo $success; ?></span>
        </div>
        <?php endif; ?>
        
        <?php if (isset($error)): ?>
        <div class="alert error">
            <i class="fas fa-exclamation-circle"></i>
            <span><?php echo $error; ?></span>
        </div>
        <?php endif; ?>
        
        <div class="page-header">
            <h2><i class="fas fa-users"></i> Kelola Akun Guru</h2>
            <button class="btn-primary" onclick="openAddModal()">
                <i class="fas fa-plus"></i> Tambah Guru
            </button>
        </div>
        
        <div class="card">
            <div class="table-responsive">
                <table>
                    <thead>
                        <tr>
                            <th>NIP</th>
                            <th>Nama</th>
                            <th>Username</th>
                            <th>Email</th>
                            <th>Telepon</th>
                            <th>Status</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (count($guru_list) > 0): ?>
                            <?php foreach ($guru_list as $guru): ?>
                            <tr>
                                <td><?php echo $guru['nip']; ?></td>
                                <td><strong><?php echo $guru['nama']; ?></strong></td>
                                <td><?php echo $guru['username']; ?></td>
                                <td><?php echo $guru['email']; ?></td>
                                <td><?php echo $guru['telepon']; ?></td>
                                <td>
                                    <span class="badge <?php echo $guru['status'] == 'aktif' ? 'success' : 'danger'; ?>">
                                        <?php echo ucfirst($guru['status']); ?>
                                    </span>
                                </td>
                                <td>
                                    <button class="btn-action btn-edit" onclick='openEditModal(<?php echo json_encode($guru); ?>)'>
                                        <i class="fas fa-edit"></i> Edit
                                    </button>
                                    <button class="btn-action btn-delete" onclick="deleteGuru(<?php echo $guru['id']; ?>, '<?php echo $guru['nama']; ?>')">
                                        <i class="fas fa-trash"></i> Hapus
                                    </button>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="7" style="text-align: center; padding: 40px; color: #9ca3af;">
                                    <i class="fas fa-inbox" style="font-size: 48px; display: block; margin-bottom: 10px;"></i>
                                    Belum ada data guru
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    
    <!-- Add Modal -->
    <div id="addModal" class="modal">
        <div class="modal-content">
            <div class="modal-header">
                <h3><i class="fas fa-user-plus"></i> Tambah Guru Baru</h3>
                <button class="btn-close" onclick="closeAddModal()">
                    <i class="fas fa-times"></i>
                </button>
            </div>
            <form method="POST">
                <input type="hidden" name="action" value="add">
                <div class="form-row">
                    <div class="form-group">
                        <label>NIP</label>
                        <input type="text" name="nip" required>
                    </div>
                    <div class="form-group">
                        <label>Username</label>
                        <input type="text" name="username" required>
                    </div>
                </div>
                <div class="form-group">
                    <label>Password</label>
                    <input type="password" name="password" required>
                </div>
                <div class="form-group">
                    <label>Nama Lengkap</label>
                    <input type="text" name="nama" required>
                </div>
                <div class="form-row">
                    <div class="form-group">
                        <label>Email</label>
                        <input type="email" name="email">
                    </div>
                    <div class="form-group">
                        <label>Telepon</label>
                        <input type="text" name="telepon">
                    </div>
                </div>
                <div class="form-group">
                    <label>Alamat</label>
                    <textarea name="alamat"></textarea>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn-secondary" onclick="closeAddModal()">Batal</button>
                    <button type="submit" class="btn-primary">
                        <i class="fas fa-save"></i> Simpan
                    </button>
                </div>
            </form>
        </div>
    </div>
    
    <!-- Edit Modal -->
    <div id="editModal" class="modal">
        <div class="modal-content">
            <div class="modal-header">
                <h3><i class="fas fa-edit"></i> Edit Data Guru</h3>
                <button class="btn-close" onclick="closeEditModal()">
                    <i class="fas fa-times"></i>
                </button>
            </div>
            <form method="POST" id="editForm">
                <input type="hidden" name="action" value="edit">
                <input type="hidden" name="id" id="edit_id">
                <div class="form-row">
                    <div class="form-group">
                        <label>NIP</label>
                        <input type="text" name="nip" id="edit_nip" required>
                    </div>
                    <div class="form-group">
                        <label>Username</label>
                        <input type="text" name="username" id="edit_username" required>
                    </div>
                </div>
                <div class="form-group">
                    <label>Password <small>(Kosongkan jika tidak ingin mengubah)</small></label>
                    <input type="password" name="password" id="edit_password">
                </div>
                <div class="form-group">
                    <label>Nama Lengkap</label>
                    <input type="text" name="nama" id="edit_nama" required>
                </div>
                <div class="form-row">
                    <div class="form-group">
                        <label>Email</label>
                        <input type="email" name="email" id="edit_email">
                    </div>
                    <div class="form-group">
                        <label>Telepon</label>
                        <input type="text" name="telepon" id="edit_telepon">
                    </div>
                </div>
                <div class="form-group">
                    <label>Alamat</label>
                    <textarea name="alamat" id="edit_alamat"></textarea>
                </div>
                <div class="form-group">
                    <label>Status</label>
                    <select name="status" id="edit_status" required>
                        <option value="aktif">Aktif</option>
                        <option value="nonaktif">Non-Aktif</option>
                    </select>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn-secondary" onclick="closeEditModal()">Batal</button>
                    <button type="submit" class="btn-primary">
                        <i class="fas fa-save"></i> Update
                    </button>
                </div>
            </form>
        </div>
    </div>
    
    <!-- Delete Form -->
    <form method="POST" id="deleteForm" style="display: none;">
        <input type="hidden" name="action" value="delete">
        <input type="hidden" name="id" id="delete_id">
    </form>
    
    <script>
        function openAddModal() {
            document.getElementById('addModal').classList.add('active');
        }
        
        function closeAddModal() {
            document.getElementById('addModal').classList.remove('active');
        }
        
        function openEditModal(guru) {
            document.getElementById('edit_id').value = guru.id;
            document.getElementById('edit_nip').value = guru.nip;
            document.getElementById('edit_username').value = guru.username;
            document.getElementById('edit_nama').value = guru.nama;
            document.getElementById('edit_email').value = guru.email || '';
            document.getElementById('edit_telepon').value = guru.telepon || '';
            document.getElementById('edit_alamat').value = guru.alamat || '';
            document.getElementById('edit_status').value = guru.status;
            document.getElementById('editModal').classList.add('active');
        }
        
        function closeEditModal() {
            document.getElementById('editModal').classList.remove('active');
        }
        
        function deleteGuru(id, nama) {
            if (confirm('Apakah Anda yakin ingin menghapus guru ' + nama + '? Semua data siswa dan absensi terkait juga akan terhapus!')) {
                document.getElementById('delete_id').value = id;
                document.getElementById('deleteForm').submit();
            }
        }
        
        // Close modal when clicking outside
        window.onclick = function(event) {
            if (event.target.classList.contains('modal')) {
                event.target.classList.remove('active');
            }
        }
    </script>
</body>
</html>
