<?php
session_start();
if (!isset($_SESSION['admin_id'])) {
    header('Location: ../login.php');
    exit();
}

require_once '../config/database.php';
$conn = getConnection();

// Handle form submissions
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (isset($_POST['action'])) {
        if ($_POST['action'] == 'update_profile') {
            $nama = $_POST['nama'];
            $email = $_POST['email'];
            $username = $_POST['username'];
            
            $stmt = $conn->prepare("UPDATE admin SET nama=?, email=?, username=? WHERE id=?");
            $stmt->bind_param("sssi", $nama, $email, $username, $_SESSION['admin_id']);
            
            if ($stmt->execute()) {
                $_SESSION['admin_nama'] = $nama;
                $success = "Profil berhasil diperbarui!";
            } else {
                $error = "Gagal memperbarui profil!";
            }
            $stmt->close();
        } elseif ($_POST['action'] == 'change_password') {
            $old_password = $_POST['old_password'];
            $new_password = $_POST['new_password'];
            $confirm_password = $_POST['confirm_password'];
            
            // Verify old password
            $admin = $conn->query("SELECT password FROM admin WHERE id=" . $_SESSION['admin_id'])->fetch_assoc();
            
            if (password_verify($old_password, $admin['password'])) {
                if ($new_password == $confirm_password) {
                    $hashed = password_hash($new_password, PASSWORD_DEFAULT);
                    $stmt = $conn->prepare("UPDATE admin SET password=? WHERE id=?");
                    $stmt->bind_param("si", $hashed, $_SESSION['admin_id']);
                    
                    if ($stmt->execute()) {
                        $success = "Password berhasil diubah!";
                    } else {
                        $error = "Gagal mengubah password!";
                    }
                    $stmt->close();
                } else {
                    $error = "Password baru tidak cocok!";
                }
            } else {
                $error = "Password lama salah!";
            }
        }
    }
}

// Get admin data
$admin = $conn->query("SELECT * FROM admin WHERE id=" . $_SESSION['admin_id'])->fetch_assoc();

// Get statistics
$total_guru = $conn->query("SELECT COUNT(*) as count FROM guru")->fetch_assoc()['count'];
$total_siswa = $conn->query("SELECT COUNT(*) as count FROM siswa")->fetch_assoc()['count'];
$total_absensi = $conn->query("SELECT COUNT(*) as count FROM absensi")->fetch_assoc()['count'];

$conn->close();
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pengaturan - SIPANCUR MOBILE</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Poppins', sans-serif;
            background: #f3f4f6;
            display: flex;
            min-height: 100vh;
        }
        
        /* Sidebar */
        .sidebar {
            width: 280px;
            background: white;
            box-shadow: 2px 0 10px rgba(0,0,0,0.08);
            position: fixed;
            left: 0;
            top: 0;
            bottom: 0;
            z-index: 1000;
            display: flex;
            flex-direction: column;
        }
        
        .sidebar-header {
            padding: 30px 25px;
            background: linear-gradient(135deg, #4ade80 0%, #22c55e 100%);
            color: white;
        }
        
        .sidebar-logo {
            display: flex;
            align-items: center;
            gap: 15px;
        }
        
        .sidebar-logo img {
            width: 50px;
            height: 50px;
            border-radius: 12px;
            border: 2px solid rgba(255,255,255,0.3);
            box-shadow: 0 4px 10px rgba(0,0,0,0.1);
        }
        
        .sidebar-logo-text h1 {
            font-size: 20px;
            font-weight: 700;
            margin-bottom: 2px;
        }
        
        .sidebar-logo-text p {
            font-size: 11px;
            opacity: 0.9;
            font-weight: 400;
        }
        
        .sidebar-user {
            padding: 25px;
            border-bottom: 1px solid #e5e7eb;
            background: #f9fafb;
        }
        
        .user-info {
            display: flex;
            align-items: center;
            gap: 15px;
        }
        
        .user-avatar {
            width: 50px;
            height: 50px;
            background: linear-gradient(135deg, #4ade80 0%, #22c55e 100%);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 20px;
            font-weight: 700;
            box-shadow: 0 4px 12px rgba(74, 222, 128, 0.3);
            flex-shrink: 0;
        }
        
        .user-details {
            flex: 1;
            min-width: 0;
        }
        
        .user-details h3 {
            font-size: 15px;
            font-weight: 600;
            color: #1f2937;
            margin: 0 0 3px 0;
            line-height: 1.2;
        }
        
        .user-details p {
            font-size: 12px;
            color: #6b7280;
            font-weight: 500;
            margin: 0;
            line-height: 1.2;
        }
        
        .sidebar-menu {
            flex: 1;
            padding: 25px 0;
            overflow-y: auto;
        }
        
        .menu-section {
            margin-bottom: 30px;
        }
        
        .menu-title {
            padding: 0 25px;
            font-size: 11px;
            font-weight: 700;
            color: #9ca3af;
            text-transform: uppercase;
            letter-spacing: 1px;
            margin-bottom: 10px;
        }
        
        .menu-item {
            display: flex;
            align-items: center;
            gap: 15px;
            padding: 14px 25px;
            margin: 0 15px;
            color: #6b7280;
            text-decoration: none;
            transition: all 0.3s;
            position: relative;
            border-radius: 10px;
        }
        
        .menu-item:hover {
            background: #f3f4f6;
            color: #22c55e;
        }
        
        .menu-item.active {
            background: linear-gradient(135deg, rgba(74, 222, 128, 0.15) 0%, rgba(34, 197, 94, 0.15) 100%);
            color: #22c55e;
            font-weight: 600;
        }
        
        .menu-item.active::before {
            content: '';
            position: absolute;
            left: -15px;
            top: 50%;
            transform: translateY(-50%);
            width: 4px;
            height: 70%;
            background: #22c55e;
            border-radius: 0 4px 4px 0;
        }
        
        .menu-item i {
            width: 22px;
            font-size: 20px;
            text-align: center;
        }
        
        .menu-item span {
            font-size: 14px;
            font-weight: 500;
        }
        
        .sidebar-footer {
            padding: 25px;
            border-top: 1px solid #e5e7eb;
            background: #f9fafb;
        }
        
        .btn-logout {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 10px;
            width: 100%;
            padding: 14px;
            background: linear-gradient(135deg, #f87171 0%, #ef4444 100%);
            color: white;
            text-decoration: none;
            border-radius: 12px;
            font-size: 14px;
            font-weight: 600;
            transition: all 0.3s;
            box-shadow: 0 4px 12px rgba(239, 68, 68, 0.2);
        }
        
        .btn-logout:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(239, 68, 68, 0.3);
        }
        
        .btn-logout:active {
            transform: translateY(0);
        }
        
        /* Main Content */
        .main-content {
            margin-left: 280px;
            flex: 1;
            padding: 30px;
        }
        
        .page-header {
            margin-bottom: 30px;
        }
        
        .page-header h2 {
            font-size: 28px;
            font-weight: 700;
            color: #1f2937;
            margin-bottom: 5px;
            display: flex;
            align-items: center;
            gap: 12px;
        }
        
        .page-header p {
            color: #6b7280;
            font-size: 14px;
        }
        
        .alert {
            padding: 15px 20px;
            border-radius: 10px;
            margin-bottom: 20px;
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        .alert.success {
            background: #d1fae5;
            color: #065f46;
        }
        
        .alert.error {
            background: #fee2e2;
            color: #991b1b;
        }
        
        .settings-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 25px;
            margin-bottom: 30px;
        }
        
        .card {
            background: white;
            border-radius: 15px;
            padding: 25px;
            box-shadow: 0 4px 15px rgba(0,0,0,0.05);
        }
        
        .card h3 {
            font-size: 18px;
            font-weight: 600;
            color: #1f2937;
            margin-bottom: 20px;
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        .card h3 i {
            color: #22c55e;
        }
        
        .form-group {
            margin-bottom: 20px;
        }
        
        .form-group label {
            display: block;
            color: #374151;
            font-weight: 500;
            margin-bottom: 8px;
            font-size: 14px;
        }
        
        .form-group input {
            width: 100%;
            padding: 12px 15px;
            border: 2px solid #e5e7eb;
            border-radius: 8px;
            font-size: 14px;
            font-family: 'Poppins', sans-serif;
            transition: all 0.3s;
        }
        
        .form-group input:focus {
            outline: none;
            border-color: #4ade80;
            box-shadow: 0 0 0 3px rgba(74, 222, 128, 0.1);
        }
        
        .form-group input:disabled {
            background: #f9fafb;
            cursor: not-allowed;
        }
        
        .btn-primary {
            background: linear-gradient(135deg, #4ade80 0%, #22c55e 100%);
            color: white;
            padding: 12px 24px;
            border: none;
            border-radius: 10px;
            cursor: pointer;
            font-size: 14px;
            font-weight: 600;
            display: inline-flex;
            align-items: center;
            gap: 8px;
            transition: all 0.3s;
            width: 100%;
            justify-content: center;
        }
        
        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(74, 222, 128, 0.3);
        }
        
        .stats-mini {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 15px;
            margin-top: 20px;
        }
        
        .stat-mini {
            background: linear-gradient(135deg, #f9fafb 0%, #f3f4f6 100%);
            padding: 15px;
            border-radius: 10px;
            text-align: center;
        }
        
        .stat-mini .value {
            font-size: 24px;
            font-weight: 700;
            color: #22c55e;
            margin-bottom: 5px;
        }
        
        .stat-mini .label {
            font-size: 12px;
            color: #6b7280;
        }
        
        .info-item {
            display: flex;
            justify-content: space-between;
            padding: 12px 0;
            border-bottom: 1px solid #f3f4f6;
        }
        
        .info-item:last-child {
            border-bottom: none;
        }
        
        .info-label {
            font-size: 14px;
            color: #6b7280;
        }
        
        .info-value {
            font-size: 14px;
            font-weight: 600;
            color: #1f2937;
        }
        
        @media (max-width: 768px) {
            .sidebar {
                width: 75px;
            }
            
            .sidebar-logo-text,
            .sidebar-user,
            .menu-title,
            .menu-item span,
            .btn-logout span {
                display: none;
            }
            
            .sidebar-header {
                padding: 25px 12px;
            }
            
            .sidebar-logo {
                justify-content: center;
            }
            
            .sidebar-logo img {
                width: 45px;
                height: 45px;
            }
            
            .menu-item {
                justify-content: center;
                margin: 8px;
                padding: 16px 0;
            }
            
            .menu-item.active::before {
                left: -8px;
                height: 100%;
            }
            
            .menu-item i {
                width: auto;
                font-size: 22px;
            }
            
            .btn-logout {
                padding: 16px 10px;
                justify-content: center;
            }
            
            .main-content {
                margin-left: 75px;
                padding: 20px;
            }
            
            .settings-grid {
                grid-template-columns: 1fr;
            }
            
            .stats-mini {
                grid-template-columns: 1fr;
            }
        }
    </style>
</head>
<body>
    <!-- Sidebar -->
    <div class="sidebar">
        <div class="sidebar-header">
            <div class="sidebar-logo">
                <img src="../logo.png" alt="Logo">
                <div class="sidebar-logo-text">
                    <h1>SIPANCUR</h1>
                    <p>SMAN 1 AJIBARANG</p>
                </div>
            </div>
        </div>
        
        <div class="sidebar-user">
            <div class="user-info">
                <div class="user-avatar">A</div>
                <div class="user-details">
                    <h3>Administrator</h3>
                    <p>Super Admin</p>
                </div>
            </div>
        </div>
        
        <div class="sidebar-menu">
            <div class="menu-section">
                <div class="menu-title">Menu Utama</div>
                <a href="dashboard.php" class="menu-item">
                    <i class="fas fa-home"></i>
                    <span>Dashboard</span>
                </a>
                <a href="guru.php" class="menu-item">
                    <i class="fas fa-users"></i>
                    <span>Kelola Guru</span>
                </a>
                <a href="siswa.php" class="menu-item">
                    <i class="fas fa-user-graduate"></i>
                    <span>Data Siswa</span>
                </a>
                <a href="reporting.php" class="menu-item">
                    <i class="fas fa-chart-bar"></i>
                    <span>Reporting</span>
                </a>
                <a href="statistik.php" class="menu-item">
                    <i class="fas fa-chart-pie"></i>
                    <span>Statistik</span>
                </a>
                <a href="pengaturan.php" class="menu-item active">
                    <i class="fas fa-cog"></i>
                    <span>Pengaturan</span>
                </a>
            </div>
        </div>
        
        <div class="sidebar-footer">
            <a href="../logout.php" class="btn-logout">
                <i class="fas fa-sign-out-alt"></i>
                <span>Keluar</span>
            </a>
        </div>
    </div>
    
    <!-- Main Content -->
    <div class="main-content">
        <div class="page-header">
            <h2><i class="fas fa-cog"></i> Pengaturan Admin</h2>
            <p>Kelola profil dan pengaturan akun administrator</p>
        </div>
        
        <?php if (isset($success)): ?>
        <div class="alert success">
            <i class="fas fa-check-circle"></i>
            <span><?php echo $success; ?></span>
        </div>
        <?php endif; ?>
        
        <?php if (isset($error)): ?>
        <div class="alert error">
            <i class="fas fa-exclamation-circle"></i>
            <span><?php echo $error; ?></span>
        </div>
        <?php endif; ?>
        
        <div class="settings-grid">
            <!-- Profile Card -->
            <div class="card">
                <h3><i class="fas fa-user"></i> Profil Admin</h3>
                <form method="POST">
                    <input type="hidden" name="action" value="update_profile">
                    <div class="form-group">
                        <label>Nama Lengkap</label>
                        <input type="text" name="nama" value="<?php echo $admin['nama']; ?>" required>
                    </div>
                    <div class="form-group">
                        <label>Email</label>
                        <input type="email" name="email" value="<?php echo $admin['email']; ?>">
                    </div>
                    <div class="form-group">
                        <label>Username</label>
                        <input type="text" name="username" value="<?php echo $admin['username']; ?>" required>
                    </div>
                    <button type="submit" class="btn-primary">
                        <i class="fas fa-save"></i> Simpan Perubahan
                    </button>
                </form>
            </div>
            
            <!-- Password Card -->
            <div class="card">
                <h3><i class="fas fa-lock"></i> Ubah Password</h3>
                <form method="POST">
                    <input type="hidden" name="action" value="change_password">
                    <div class="form-group">
                        <label>Password Lama</label>
                        <input type="password" name="old_password" required>
                    </div>
                    <div class="form-group">
                        <label>Password Baru</label>
                        <input type="password" name="new_password" required>
                    </div>
                    <div class="form-group">
                        <label>Konfirmasi Password Baru</label>
                        <input type="password" name="confirm_password" required>
                    </div>
                    <button type="submit" class="btn-primary">
                        <i class="fas fa-key"></i> Ubah Password
                    </button>
                </form>
            </div>
            
            <!-- Info Card -->
            <div class="card">
                <h3><i class="fas fa-info-circle"></i> Informasi Akun</h3>
                <div class="info-item">
                    <span class="info-label">Username</span>
                    <span class="info-value"><?php echo $admin['username']; ?></span>
                </div>
                <div class="info-item">
                    <span class="info-label">Nama</span>
                    <span class="info-value"><?php echo $admin['nama']; ?></span>
                </div>
                <div class="info-item">
                    <span class="info-label">Email</span>
                    <span class="info-value"><?php echo $admin['email'] ?: '-'; ?></span>
                </div>
                <div class="info-item">
                    <span class="info-label">Terdaftar Sejak</span>
                    <span class="info-value"><?php echo date('d M Y', strtotime($admin['created_at'])); ?></span>
                </div>
                
                <div class="stats-mini">
                    <div class="stat-mini">
                        <div class="value"><?php echo $total_guru; ?></div>
                        <div class="label">Guru</div>
                    </div>
                    <div class="stat-mini">
                        <div class="value"><?php echo $total_siswa; ?></div>
                        <div class="label">Siswa</div>
                    </div>
                    <div class="stat-mini">
                        <div class="value"><?php echo $total_absensi; ?></div>
                        <div class="label">Absensi</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
</html>
