<?php
session_start();
if (!isset($_SESSION['admin_id'])) {
    header('Location: ../login.php');
    exit();
}

require_once '../config/database.php';
$conn = getConnection();

// Get filter
$filter = $_GET['filter'] ?? 'harian';
$tanggal = $_GET['tanggal'] ?? date('Y-m-d');
$bulan = $_GET['bulan'] ?? date('Y-m');
$guru_id = $_GET['guru_id'] ?? '';
$kelas = $_GET['kelas'] ?? '';

// Get guru list for filter
$guru_list = $conn->query("SELECT id, nama FROM guru ORDER BY nama")->fetch_all(MYSQLI_ASSOC);

// Get kelas list for filter
$kelas_list = $conn->query("SELECT DISTINCT kelas FROM siswa WHERE kelas IS NOT NULL AND kelas != '' ORDER BY kelas")->fetch_all(MYSQLI_ASSOC);

// Prepare query based on filter
if ($filter == 'harian') {
    $where = "WHERE DATE(a.tanggal) = '$tanggal'";
    $title = "Laporan Harian - " . date('d F Y', strtotime($tanggal));
} elseif ($filter == 'mingguan') {
    $start_week = date('Y-m-d', strtotime('monday this week', strtotime($tanggal)));
    $end_week = date('Y-m-d', strtotime('sunday this week', strtotime($tanggal)));
    $where = "WHERE a.tanggal BETWEEN '$start_week' AND '$end_week'";
    $title = "Laporan Mingguan - " . date('d M', strtotime($start_week)) . " s/d " . date('d M Y', strtotime($end_week));
} else { // bulanan
    $start_month = $bulan . '-01';
    $end_month = date('Y-m-t', strtotime($start_month));
    $where = "WHERE a.tanggal BETWEEN '$start_month' AND '$end_month'";
    $title = "Laporan Bulanan - " . date('F Y', strtotime($start_month));
}

if ($guru_id) {
    $where .= " AND a.guru_id = $guru_id";
}

if ($kelas) {
    $where .= " AND s.kelas = '$kelas'";
}

// Get summary statistics
$stats = $conn->query("
    SELECT 
        COUNT(DISTINCT a.siswa_id) as total_siswa,
        SUM(CASE WHEN a.status='hadir' THEN 1 ELSE 0 END) as total_hadir,
        SUM(CASE WHEN a.status='izin' THEN 1 ELSE 0 END) as total_izin,
        SUM(CASE WHEN a.status='sakit' THEN 1 ELSE 0 END) as total_sakit,
        SUM(CASE WHEN a.status='alpha' THEN 1 ELSE 0 END) as total_alpha
    FROM absensi a
    JOIN siswa s ON a.siswa_id = s.id
    $where
")->fetch_assoc();

// Get detailed data
$detail_data = $conn->query("
    SELECT 
        s.nama as siswa_nama,
        s.nis,
        s.kelas,
        g.nama as guru_nama,
        a.tanggal,
        a.status,
        a.keterangan
    FROM absensi a
    JOIN siswa s ON a.siswa_id = s.id
    JOIN guru g ON a.guru_id = g.id
    $where
    ORDER BY a.tanggal DESC, s.nama ASC
")->fetch_all(MYSQLI_ASSOC);

// Get data for pie chart
$chart_data = [
    'hadir' => $stats['total_hadir'] ?? 0,
    'izin' => $stats['total_izin'] ?? 0,
    'sakit' => $stats['total_sakit'] ?? 0,
    'alpha' => $stats['total_alpha'] ?? 0
];

$conn->close();
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reporting - SIPANCUR MOBILE</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Poppins', sans-serif;
            background: #f3f4f6;
            display: flex;
            min-height: 100vh;
        }
        
        /* Sidebar */
        .sidebar {
            width: 280px;
            background: white;
            box-shadow: 2px 0 10px rgba(0,0,0,0.08);
            position: fixed;
            left: 0;
            top: 0;
            bottom: 0;
            z-index: 1000;
            display: flex;
            flex-direction: column;
        }
        
        .sidebar-header {
            padding: 30px 25px;
            background: linear-gradient(135deg, #4ade80 0%, #22c55e 100%);
            color: white;
        }
        
        .sidebar-logo {
            display: flex;
            align-items: center;
            gap: 15px;
        }
        
        .sidebar-logo img {
            width: 50px;
            height: 50px;
            border-radius: 12px;
            border: 2px solid rgba(255,255,255,0.3);
            box-shadow: 0 4px 10px rgba(0,0,0,0.1);
        }
        
        .sidebar-logo-text h1 {
            font-size: 20px;
            font-weight: 700;
            margin-bottom: 2px;
        }
        
        .sidebar-logo-text p {
            font-size: 11px;
            opacity: 0.9;
            font-weight: 400;
        }
        
        .sidebar-user {
            padding: 25px;
            border-bottom: 1px solid #e5e7eb;
            background: #f9fafb;
        }
        
        .user-info {
            display: flex;
            align-items: center;
            gap: 15px;
        }
        
        .user-avatar {
            width: 50px;
            height: 50px;
            background: linear-gradient(135deg, #4ade80 0%, #22c55e 100%);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 20px;
            font-weight: 700;
            box-shadow: 0 4px 12px rgba(74, 222, 128, 0.3);
            flex-shrink: 0;
        }
        
        .user-details {
            flex: 1;
            min-width: 0;
        }
        
        .user-details h3 {
            font-size: 15px;
            font-weight: 600;
            color: #1f2937;
            margin: 0 0 3px 0;
            line-height: 1.2;
        }
        
        .user-details p {
            font-size: 12px;
            color: #6b7280;
            font-weight: 500;
            margin: 0;
            line-height: 1.2;
        }
        
        .sidebar-menu {
            flex: 1;
            padding: 25px 0;
            overflow-y: auto;
        }
        
        .menu-section {
            margin-bottom: 30px;
        }
        
        .menu-title {
            padding: 0 25px;
            font-size: 11px;
            font-weight: 700;
            color: #9ca3af;
            text-transform: uppercase;
            letter-spacing: 1px;
            margin-bottom: 10px;
        }
        
        .menu-item {
            display: flex;
            align-items: center;
            gap: 15px;
            padding: 14px 25px;
            margin: 0 15px;
            color: #6b7280;
            text-decoration: none;
            transition: all 0.3s;
            position: relative;
            border-radius: 10px;
        }
        
        .menu-item:hover {
            background: #f3f4f6;
            color: #22c55e;
        }
        
        .menu-item.active {
            background: linear-gradient(135deg, rgba(74, 222, 128, 0.15) 0%, rgba(34, 197, 94, 0.15) 100%);
            color: #22c55e;
            font-weight: 600;
        }
        
        .menu-item.active::before {
            content: '';
            position: absolute;
            left: -15px;
            top: 50%;
            transform: translateY(-50%);
            width: 4px;
            height: 70%;
            background: #22c55e;
            border-radius: 0 4px 4px 0;
        }
        
        .menu-item i {
            width: 22px;
            font-size: 20px;
            text-align: center;
        }
        
        .menu-item span {
            font-size: 14px;
            font-weight: 500;
        }
        
        .sidebar-footer {
            padding: 25px;
            border-top: 1px solid #e5e7eb;
            background: #f9fafb;
        }
        
        .btn-logout {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 10px;
            width: 100%;
            padding: 14px;
            background: linear-gradient(135deg, #f87171 0%, #ef4444 100%);
            color: white;
            text-decoration: none;
            border-radius: 12px;
            font-size: 14px;
            font-weight: 600;
            transition: all 0.3s;
            box-shadow: 0 4px 12px rgba(239, 68, 68, 0.2);
        }
        
        .btn-logout:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(239, 68, 68, 0.3);
        }
        
        .btn-logout:active {
            transform: translateY(0);
        }
        
        /* Main Content */
        .main-content {
            margin-left: 280px;
            flex: 1;
            padding: 30px;
        }
        
        .page-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 30px;
        }
        
        .page-header h2 {
            font-size: 28px;
            font-weight: 700;
            color: #1f2937;
            display: flex;
            align-items: center;
            gap: 12px;
        }
        
        .filter-card {
            background: white;
            border-radius: 15px;
            padding: 25px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.05);
            margin-bottom: 20px;
        }
        
        .filter-card h3 {
            color: #1f2937;
            font-size: 18px;
            margin-bottom: 20px;
            font-weight: 600;
        }
        
        .filter-form {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 15px;
            align-items: end;
        }
        
        .form-group {
            margin-bottom: 0;
        }
        
        .form-group label {
            display: block;
            color: #374151;
            font-weight: 500;
            margin-bottom: 8px;
            font-size: 14px;
        }
        
        .form-group input,
        .form-group select {
            width: 100%;
            padding: 12px 15px;
            border: 2px solid #e5e7eb;
            border-radius: 8px;
            font-size: 14px;
            font-family: 'Poppins', sans-serif;
        }
        
        .btn-filter {
            background: linear-gradient(135deg, #4ade80 0%, #22c55e 100%);
            color: white;
            padding: 12px 24px;
            border: none;
            border-radius: 8px;
            cursor: pointer;
            font-size: 14px;
            font-weight: 500;
            display: flex;
            align-items: center;
            gap: 8px;
            justify-content: center;
        }
        
        .data-card {
            background: white;
            border-radius: 15px;
            padding: 25px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.05);
        }
        
        .data-card h3 {
            color: #1f2937;
            font-size: 18px;
            margin-bottom: 20px;
            font-weight: 600;
        }
        
        .table-responsive {
            overflow-x: auto;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
        }
        
        table thead {
            background: #f9fafb;
        }
        
        table th {
            padding: 12px;
            text-align: left;
            color: #6b7280;
            font-weight: 600;
            font-size: 12px;
            text-transform: uppercase;
            border-bottom: 2px solid #e5e7eb;
        }
        
        table td {
            padding: 12px;
            color: #374151;
            border-bottom: 1px solid #f3f4f6;
            font-size: 13px;
        }
        
        .badge {
            padding: 5px 12px;
            border-radius: 20px;
            font-size: 11px;
            font-weight: 500;
        }
        
        .badge.hadir {
            background: #d1fae5;
            color: #065f46;
        }
        
        .badge.izin {
            background: #dbeafe;
            color: #1e40af;
        }
        
        .badge.sakit {
            background: #fef3c7;
            color: #92400e;
        }
        
        .badge.alpha {
            background: #fee2e2;
            color: #991b1b;
        }
        
        @media (max-width: 768px) {
            .sidebar {
                width: 75px;
            }
            
            .sidebar-logo-text,
            .sidebar-user,
            .menu-title,
            .menu-item span,
            .btn-logout span {
                display: none;
            }
            
            .sidebar-header {
                padding: 25px 12px;
            }
            
            .sidebar-logo {
                justify-content: center;
            }
            
            .sidebar-logo img {
                width: 45px;
                height: 45px;
            }
            
            .menu-item {
                justify-content: center;
                margin: 8px;
                padding: 16px 0;
            }
            
            .menu-item.active::before {
                left: -8px;
                height: 100%;
            }
            
            .menu-item i {
                width: auto;
                font-size: 22px;
            }
            
            .btn-logout {
                padding: 16px 10px;
                justify-content: center;
            }
            
            .main-content {
                margin-left: 75px;
                padding: 20px;
            }
            
            .header-content {
                flex-direction: column;
                gap: 15px;
                text-align: center;
            }
            
            .header-right {
                flex-direction: column;
            }
            
            .filter-form {
                grid-template-columns: 1fr;
            }
        }
        
        @media print {
            .sidebar, .filter-card {
                display: none;
            }
            
            body {
                background: white;
            }
            
            .main-content {
                margin-left: 0;
                padding: 20px;
            }
        }
    </style>
</head>
<body>
    <!-- Sidebar -->
    <div class="sidebar">
        <div class="sidebar-header">
            <div class="sidebar-logo">
                <img src="../logo.png" alt="Logo">
                <div class="sidebar-logo-text">
                    <h1>SIPANCUR</h1>
                    <p>SMAN 1 AJIBARANG</p>
                </div>
            </div>
        </div>
        
        <div class="sidebar-user">
            <div class="user-info">
                <div class="user-avatar">A</div>
                <div class="user-details">
                    <h3>Administrator</h3>
                    <p>Super Admin</p>
                </div>
            </div>
        </div>
        
        <div class="sidebar-menu">
            <div class="menu-section">
                <div class="menu-title">Menu Utama</div>
                <a href="dashboard.php" class="menu-item">
                    <i class="fas fa-home"></i>
                    <span>Dashboard</span>
                </a>
                <a href="guru.php" class="menu-item">
                    <i class="fas fa-users"></i>
                    <span>Kelola Guru</span>
                </a>
                <a href="siswa.php" class="menu-item">
                    <i class="fas fa-user-graduate"></i>
                    <span>Data Siswa</span>
                </a>
                <a href="reporting.php" class="menu-item active">
                    <i class="fas fa-chart-bar"></i>
                    <span>Reporting</span>
                </a>
                <a href="statistik.php" class="menu-item">
                    <i class="fas fa-chart-pie"></i>
                    <span>Statistik</span>
                </a>
                <a href="pengaturan.php" class="menu-item">
                    <i class="fas fa-cog"></i>
                    <span>Pengaturan</span>
                </a>
            </div>
        </div>
        
        <div class="sidebar-footer">
            <a href="../logout.php" class="btn-logout">
                <i class="fas fa-sign-out-alt"></i>
                <span>Keluar</span>
            </a>
        </div>
    </div>
    
    <!-- Main Content -->
    <div class="main-content">
        <div class="filter-card">
            <h3><i class="fas fa-filter"></i> Filter Laporan</h3>
            <form method="GET" class="filter-form">
                <div class="form-group">
                    <label>Tipe Laporan</label>
                    <select name="filter" id="filterType" onchange="updateDateInput()">
                        <option value="harian" <?php echo $filter == 'harian' ? 'selected' : ''; ?>>Harian</option>
                        <option value="mingguan" <?php echo $filter == 'mingguan' ? 'selected' : ''; ?>>Mingguan</option>
                        <option value="bulanan" <?php echo $filter == 'bulanan' ? 'selected' : ''; ?>>Bulanan</option>
                    </select>
                </div>
                
                <div class="form-group" id="tanggalGroup">
                    <label>Tanggal</label>
                    <input type="date" name="tanggal" value="<?php echo $tanggal; ?>">
                </div>
                
                <div class="form-group" id="bulanGroup" style="display: none;">
                    <label>Bulan</label>
                    <input type="month" name="bulan" value="<?php echo $bulan; ?>">
                </div>
                
                <div class="form-group">
                    <label>Guru</label>
                    <select name="guru_id">
                        <option value="">Semua Guru</option>
                        <?php foreach ($guru_list as $guru): ?>
                            <option value="<?php echo $guru['id']; ?>" <?php echo $guru_id == $guru['id'] ? 'selected' : ''; ?>>
                                <?php echo $guru['nama']; ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                
                <div class="form-group">
                    <label>Kelas</label>
                    <select name="kelas">
                        <option value="">Semua Kelas</option>
                        <?php foreach ($kelas_list as $k): ?>
                            <option value="<?php echo $k['kelas']; ?>" <?php echo $kelas == $k['kelas'] ? 'selected' : ''; ?>>
                                <?php echo $k['kelas']; ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                
                <div class="form-group">
                    <button type="submit" class="btn-filter">
                        <i class="fas fa-search"></i> Tampilkan
                    </button>
                </div>
            </form>
            
            <?php if (count($detail_data) > 0): ?>
            <div style="margin-top: 15px; display: flex; gap: 10px;">
                <a href="export_pdf.php?<?php echo http_build_query($_GET); ?>" target="_blank" style="flex: 1; background: #ef4444; color: white; text-decoration: none; padding: 12px; border-radius: 12px; text-align: center; font-weight: 600; font-size: 14px; display: flex; align-items: center; justify-content: center; gap: 8px;">
                    <i class="fas fa-file-pdf"></i> Export PDF
                </a>
                <a href="export_excel.php?<?php echo http_build_query($_GET); ?>" style="flex: 1; background: #22c55e; color: white; text-decoration: none; padding: 12px; border-radius: 12px; text-align: center; font-weight: 600; font-size: 14px; display: flex; align-items: center; justify-content: center; gap: 8px;">
                    <i class="fas fa-file-excel"></i> Export Excel
                </a>
            </div>
            <?php endif; ?>
        </div>
        
        <div class="data-card">
            <h3>
                <i class="fas fa-table"></i> <?php echo $title; ?>
            </h3>
            <div class="table-responsive">
                <table>
                    <thead>
                        <tr>
                            <th>Tanggal</th>
                            <th>NIS</th>
                            <th>Nama Siswa</th>
                            <th>Kelas</th>
                            <th>Guru</th>
                            <th>Status</th>
                            <th>Keterangan</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (count($detail_data) > 0): ?>
                            <?php foreach ($detail_data as $data): ?>
                            <tr>
                                <td><?php echo date('d/m/Y', strtotime($data['tanggal'])); ?></td>
                                <td><?php echo $data['nis']; ?></td>
                                <td><strong><?php echo $data['siswa_nama']; ?></strong></td>
                                <td><?php echo $data['kelas']; ?></td>
                                <td><?php echo $data['guru_nama']; ?></td>
                                <td>
                                    <span class="badge <?php echo $data['status']; ?>">
                                        <?php echo ucfirst($data['status']); ?>
                                    </span>
                                </td>
                                <td><?php echo $data['keterangan'] ?? '-'; ?></td>
                            </tr>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="7" style="text-align: center; padding: 40px; color: #9ca3af;">
                                    <i class="fas fa-inbox" style="font-size: 48px; display: block; margin-bottom: 10px;"></i>
                                    Tidak ada data untuk ditampilkan
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    
    <script>
        function updateDateInput() {
            const filter = document.getElementById('filterType').value;
            const tanggalGroup = document.getElementById('tanggalGroup');
            const bulanGroup = document.getElementById('bulanGroup');
            
            if (filter === 'bulanan') {
                tanggalGroup.style.display = 'none';
                bulanGroup.style.display = 'block';
            } else {
                tanggalGroup.style.display = 'block';
                bulanGroup.style.display = 'none';
            }
        }
        
        updateDateInput();
    </script>
</body>
</html>
