<?php
session_start();
if (!isset($_SESSION['admin_id'])) {
    header('Location: ../login.php');
    exit();
}

require_once '../config/database.php';
$conn = getConnection();

// Get filter
$filter = $_GET['filter'] ?? 'harian';
$tanggal = $_GET['tanggal'] ?? date('Y-m-d');
$bulan = $_GET['bulan'] ?? date('Y-m');
$guru_id = $_GET['guru_id'] ?? '';

// Get guru list for filter
$guru_list = $conn->query("SELECT id, nama FROM guru ORDER BY nama")->fetch_all(MYSQLI_ASSOC);

// Prepare query based on filter
if ($filter == 'harian') {
    $where = "WHERE DATE(a.tanggal) = '$tanggal'";
    $title = "Laporan Harian - " . date('d F Y', strtotime($tanggal));
} elseif ($filter == 'mingguan') {
    $start_week = date('Y-m-d', strtotime('monday this week', strtotime($tanggal)));
    $end_week = date('Y-m-d', strtotime('sunday this week', strtotime($tanggal)));
    $where = "WHERE a.tanggal BETWEEN '$start_week' AND '$end_week'";
    $title = "Laporan Mingguan - " . date('d M', strtotime($start_week)) . " s/d " . date('d M Y', strtotime($end_week));
} else { // bulanan
    $start_month = $bulan . '-01';
    $end_month = date('Y-m-t', strtotime($start_month));
    $where = "WHERE a.tanggal BETWEEN '$start_month' AND '$end_month'";
    $title = "Laporan Bulanan - " . date('F Y', strtotime($start_month));
}

if ($guru_id) {
    $where .= " AND a.guru_id = $guru_id";
}

// Get summary statistics
$stats = $conn->query("
    SELECT 
        COUNT(DISTINCT a.siswa_id) as total_siswa,
        SUM(CASE WHEN a.status='hadir' THEN 1 ELSE 0 END) as total_hadir,
        SUM(CASE WHEN a.status='izin' THEN 1 ELSE 0 END) as total_izin,
        SUM(CASE WHEN a.status='sakit' THEN 1 ELSE 0 END) as total_sakit,
        SUM(CASE WHEN a.status='alpha' THEN 1 ELSE 0 END) as total_alpha
    FROM absensi a
    $where
")->fetch_assoc();

// Get detailed data
$detail_data = $conn->query("
    SELECT 
        s.nama as siswa_nama,
        s.nis,
        s.kelas,
        g.nama as guru_nama,
        a.tanggal,
        a.status,
        a.keterangan
    FROM absensi a
    JOIN siswa s ON a.siswa_id = s.id
    JOIN guru g ON a.guru_id = g.id
    $where
    ORDER BY a.tanggal DESC, s.nama ASC
")->fetch_all(MYSQLI_ASSOC);

// Get data for pie chart
$chart_data = [
    'hadir' => $stats['total_hadir'] ?? 0,
    'izin' => $stats['total_izin'] ?? 0,
    'sakit' => $stats['total_sakit'] ?? 0,
    'alpha' => $stats['total_alpha'] ?? 0
];

$conn->close();
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reporting - SIPANCUR MOBILE</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Poppins', sans-serif;
            background: #f3f4f6;
        }
        
        .header {
            background: linear-gradient(135deg, #4ade80 0%, #22c55e 100%);
            color: white;
            padding: 20px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        
        .header-content {
            display: flex;
            justify-content: space-between;
            align-items: center;
            max-width: 1200px;
            margin: 0 auto;
        }
        
        .header-left {
            display: flex;
            align-items: center;
            gap: 15px;
        }
        
        .header-left img {
            width: 50px;
            height: 50px;
            object-fit: contain;
        }
        
        .header-left h1 {
            font-size: 22px;
            font-weight: 700;
        }
        
        .header-left p {
            font-size: 13px;
            opacity: 0.9;
        }
        
        .header-right {
            display: flex;
            align-items: center;
            gap: 20px;
        }
        
        .user-info {
            text-align: right;
        }
        
        .user-info .name {
            font-weight: 600;
            font-size: 14px;
        }
        
        .user-info .role {
            font-size: 12px;
            opacity: 0.9;
        }
        
        .btn-logout {
            background: rgba(255,255,255,0.2);
            color: white;
            padding: 10px 20px;
            border-radius: 8px;
            text-decoration: none;
            font-size: 14px;
            transition: all 0.3s;
            display: flex;
            align-items: center;
            gap: 8px;
        }
        
        .btn-logout:hover {
            background: rgba(255,255,255,0.3);
        }
        
        .nav-menu {
            background: white;
            box-shadow: 0 2px 10px rgba(0,0,0,0.05);
            padding: 0;
            margin-bottom: 20px;
        }
        
        .nav-menu ul {
            list-style: none;
            display: flex;
            max-width: 1200px;
            margin: 0 auto;
            gap: 10px;
            padding: 10px 20px;
            overflow-x: auto;
        }
        
        .nav-menu ul li a {
            display: flex;
            align-items: center;
            gap: 8px;
            padding: 12px 20px;
            color: #6b7280;
            text-decoration: none;
            border-radius: 8px;
            transition: all 0.3s;
            font-size: 14px;
            font-weight: 500;
            white-space: nowrap;
        }
        
        .nav-menu ul li a:hover,
        .nav-menu ul li a.active {
            background: #4ade80;
            color: white;
        }
        
        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 20px;
        }
        
        .filter-card {
            background: white;
            border-radius: 15px;
            padding: 25px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.05);
            margin-bottom: 20px;
        }
        
        .filter-card h3 {
            color: #1f2937;
            font-size: 18px;
            margin-bottom: 20px;
            font-weight: 600;
        }
        
        .filter-form {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 15px;
            align-items: end;
        }
        
        .form-group {
            margin-bottom: 0;
        }
        
        .form-group label {
            display: block;
            color: #374151;
            font-weight: 500;
            margin-bottom: 8px;
            font-size: 14px;
        }
        
        .form-group input,
        .form-group select {
            width: 100%;
            padding: 12px 15px;
            border: 2px solid #e5e7eb;
            border-radius: 8px;
            font-size: 14px;
            font-family: 'Poppins', sans-serif;
        }
        
        .btn-filter {
            background: linear-gradient(135deg, #4ade80 0%, #22c55e 100%);
            color: white;
            padding: 12px 24px;
            border: none;
            border-radius: 8px;
            cursor: pointer;
            font-size: 14px;
            font-weight: 500;
            display: flex;
            align-items: center;
            gap: 8px;
            justify-content: center;
        }
        
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }
        
        .stat-card {
            background: white;
            border-radius: 15px;
            padding: 25px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.05);
        }
        
        .stat-card .icon {
            width: 50px;
            height: 50px;
            border-radius: 10px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 24px;
            margin-bottom: 15px;
        }
        
        .stat-card.green .icon {
            background: rgba(74, 222, 128, 0.1);
            color: #22c55e;
        }
        
        .stat-card.blue .icon {
            background: rgba(59, 130, 246, 0.1);
            color: #3b82f6;
        }
        
        .stat-card.yellow .icon {
            background: rgba(234, 179, 8, 0.1);
            color: #eab308;
        }
        
        .stat-card.red .icon {
            background: rgba(239, 68, 68, 0.1);
            color: #ef4444;
        }
        
        .stat-card .label {
            color: #6b7280;
            font-size: 13px;
            margin-bottom: 5px;
        }
        
        .stat-card .value {
            color: #1f2937;
            font-size: 28px;
            font-weight: 700;
        }
        
        .chart-grid {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 20px;
            margin-bottom: 30px;
        }
        
        .chart-card {
            background: white;
            border-radius: 15px;
            padding: 25px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.05);
        }
        
        .chart-card h3 {
            color: #1f2937;
            font-size: 18px;
            margin-bottom: 20px;
            font-weight: 600;
        }
        
        .data-card {
            background: white;
            border-radius: 15px;
            padding: 25px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.05);
        }
        
        .data-card h3 {
            color: #1f2937;
            font-size: 18px;
            margin-bottom: 20px;
            font-weight: 600;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .btn-print {
            background: #3b82f6;
            color: white;
            padding: 10px 20px;
            border: none;
            border-radius: 8px;
            cursor: pointer;
            font-size: 13px;
            display: flex;
            align-items: center;
            gap: 8px;
        }
        
        .table-responsive {
            overflow-x: auto;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
        }
        
        table thead {
            background: #f9fafb;
        }
        
        table th {
            padding: 12px;
            text-align: left;
            color: #6b7280;
            font-weight: 600;
            font-size: 12px;
            text-transform: uppercase;
            border-bottom: 2px solid #e5e7eb;
        }
        
        table td {
            padding: 12px;
            color: #374151;
            border-bottom: 1px solid #f3f4f6;
            font-size: 13px;
        }
        
        .badge {
            padding: 5px 12px;
            border-radius: 20px;
            font-size: 11px;
            font-weight: 500;
        }
        
        .badge.hadir {
            background: #d1fae5;
            color: #065f46;
        }
        
        .badge.izin {
            background: #dbeafe;
            color: #1e40af;
        }
        
        .badge.sakit {
            background: #fef3c7;
            color: #92400e;
        }
        
        .badge.alpha {
            background: #fee2e2;
            color: #991b1b;
        }
        
        @media (max-width: 768px) {
            .header-content {
                flex-direction: column;
                gap: 15px;
                text-align: center;
            }
            
            .header-right {
                flex-direction: column;
            }
            
            .filter-form {
                grid-template-columns: 1fr;
            }
            
            .stats-grid {
                grid-template-columns: 1fr;
            }
            
            .chart-grid {
                grid-template-columns: 1fr;
            }
        }
        
        @media print {
            .header, .nav-menu, .filter-card, .btn-print {
                display: none;
            }
            
            body {
                background: white;
            }
            
            .chart-grid {
                grid-template-columns: 1fr;
            }
        }
    </style>
</head>
<body>
    <div class="header">
        <div class="header-content">
            <div class="header-left">
                <img src="../logo.png" alt="Logo">
                <div>
                    <h1>SIPANCUR MOBILE</h1>
                    <p>Admin Panel</p>
                </div>
            </div>
            <div class="header-right">
                <div class="user-info">
                    <div class="name"><?php echo $_SESSION['admin_nama']; ?></div>
                    <div class="role">Administrator</div>
                </div>
                <a href="../logout.php" class="btn-logout">
                    <i class="fas fa-sign-out-alt"></i> Logout
                </a>
            </div>
        </div>
    </div>
    
    <div class="nav-menu">
        <ul>
            <li><a href="dashboard.php"><i class="fas fa-home"></i> Dashboard</a></li>
            <li><a href="guru.php"><i class="fas fa-users"></i> Kelola Guru</a></li>
            <li><a href="reporting.php" class="active"><i class="fas fa-chart-bar"></i> Reporting</a></li>
        </ul>
    </div>
    
    <div class="container">
        <div class="filter-card">
            <h3><i class="fas fa-filter"></i> Filter Laporan</h3>
            <form method="GET" class="filter-form">
                <div class="form-group">
                    <label>Tipe Laporan</label>
                    <select name="filter" id="filterType" onchange="updateDateInput()">
                        <option value="harian" <?php echo $filter == 'harian' ? 'selected' : ''; ?>>Harian</option>
                        <option value="mingguan" <?php echo $filter == 'mingguan' ? 'selected' : ''; ?>>Mingguan</option>
                        <option value="bulanan" <?php echo $filter == 'bulanan' ? 'selected' : ''; ?>>Bulanan</option>
                    </select>
                </div>
                
                <div class="form-group" id="tanggalGroup">
                    <label>Tanggal</label>
                    <input type="date" name="tanggal" value="<?php echo $tanggal; ?>">
                </div>
                
                <div class="form-group" id="bulanGroup" style="display: none;">
                    <label>Bulan</label>
                    <input type="month" name="bulan" value="<?php echo $bulan; ?>">
                </div>
                
                <div class="form-group">
                    <label>Guru</label>
                    <select name="guru_id">
                        <option value="">Semua Guru</option>
                        <?php foreach ($guru_list as $guru): ?>
                            <option value="<?php echo $guru['id']; ?>" <?php echo $guru_id == $guru['id'] ? 'selected' : ''; ?>>
                                <?php echo $guru['nama']; ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                
                <div class="form-group">
                    <button type="submit" class="btn-filter">
                        <i class="fas fa-search"></i> Tampilkan
                    </button>
                </div>
            </form>
            
            <?php if (count($detail_data) > 0): ?>
            <div style="margin-top: 15px; display: flex; gap: 10px;">
                <a href="export_pdf.php?<?php echo http_build_query($_GET); ?>" target="_blank" style="flex: 1; background: #ef4444; color: white; text-decoration: none; padding: 12px; border-radius: 12px; text-align: center; font-weight: 600; font-size: 14px; display: flex; align-items: center; justify-content: center; gap: 8px;">
                    <i class="fas fa-file-pdf"></i> Export PDF
                </a>
                <a href="export_excel.php?<?php echo http_build_query($_GET); ?>" style="flex: 1; background: #22c55e; color: white; text-decoration: none; padding: 12px; border-radius: 12px; text-align: center; font-weight: 600; font-size: 14px; display: flex; align-items: center; justify-content: center; gap: 8px;">
                    <i class="fas fa-file-excel"></i> Export Excel
                </a>
            </div>
            <?php endif; ?>
        </div>
        
        <div class="stats-grid">
            <div class="stat-card green">
                <div class="icon"><i class="fas fa-check-circle"></i></div>
                <div class="label">Hadir</div>
                <div class="value"><?php echo $stats['total_hadir'] ?? 0; ?></div>
            </div>
            
            <div class="stat-card blue">
                <div class="icon"><i class="fas fa-envelope"></i></div>
                <div class="label">Izin</div>
                <div class="value"><?php echo $stats['total_izin'] ?? 0; ?></div>
            </div>
            
            <div class="stat-card yellow">
                <div class="icon"><i class="fas fa-medkit"></i></div>
                <div class="label">Sakit</div>
                <div class="value"><?php echo $stats['total_sakit'] ?? 0; ?></div>
            </div>
            
            <div class="stat-card red">
                <div class="icon"><i class="fas fa-times-circle"></i></div>
                <div class="label">Alpha</div>
                <div class="value"><?php echo $stats['total_alpha'] ?? 0; ?></div>
            </div>
        </div>
        
        <div class="chart-grid">
            <div class="chart-card">
                <h3><i class="fas fa-chart-pie"></i> Persentase Kehadiran</h3>
                <canvas id="pieChart"></canvas>
            </div>
            
            <div class="chart-card">
                <h3><i class="fas fa-chart-bar"></i> Grafik Kehadiran</h3>
                <canvas id="barChart"></canvas>
            </div>
        </div>
        
        <div class="data-card">
            <h3>
                <span><i class="fas fa-table"></i> <?php echo $title; ?></span>
                <button class="btn-print" onclick="window.print()">
                    <i class="fas fa-print"></i> Print
                </button>
            </h3>
            <div class="table-responsive">
                <table>
                    <thead>
                        <tr>
                            <th>Tanggal</th>
                            <th>NIS</th>
                            <th>Nama Siswa</th>
                            <th>Kelas</th>
                            <th>Guru</th>
                            <th>Status</th>
                            <th>Keterangan</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (count($detail_data) > 0): ?>
                            <?php foreach ($detail_data as $data): ?>
                            <tr>
                                <td><?php echo date('d/m/Y', strtotime($data['tanggal'])); ?></td>
                                <td><?php echo $data['nis']; ?></td>
                                <td><strong><?php echo $data['siswa_nama']; ?></strong></td>
                                <td><?php echo $data['kelas']; ?></td>
                                <td><?php echo $data['guru_nama']; ?></td>
                                <td>
                                    <span class="badge <?php echo $data['status']; ?>">
                                        <?php echo ucfirst($data['status']); ?>
                                    </span>
                                </td>
                                <td><?php echo $data['keterangan'] ?? '-'; ?></td>
                            </tr>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="7" style="text-align: center; padding: 40px; color: #9ca3af;">
                                    <i class="fas fa-inbox" style="font-size: 48px; display: block; margin-bottom: 10px;"></i>
                                    Tidak ada data untuk ditampilkan
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    
    <script>
        function updateDateInput() {
            const filter = document.getElementById('filterType').value;
            const tanggalGroup = document.getElementById('tanggalGroup');
            const bulanGroup = document.getElementById('bulanGroup');
            
            if (filter === 'bulanan') {
                tanggalGroup.style.display = 'none';
                bulanGroup.style.display = 'block';
            } else {
                tanggalGroup.style.display = 'block';
                bulanGroup.style.display = 'none';
            }
        }
        
        updateDateInput();
        
        // Pie Chart
        const pieCtx = document.getElementById('pieChart').getContext('2d');
        const chartData = <?php echo json_encode($chart_data); ?>;
        
        new Chart(pieCtx, {
            type: 'doughnut',
            data: {
                labels: ['Hadir', 'Izin', 'Sakit', 'Alpha'],
                datasets: [{
                    data: [chartData.hadir, chartData.izin, chartData.sakit, chartData.alpha],
                    backgroundColor: ['#22c55e', '#3b82f6', '#eab308', '#ef4444']
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: true,
                plugins: {
                    legend: {
                        position: 'bottom',
                        labels: {
                            font: {
                                family: 'Poppins',
                                size: 12
                            },
                            usePointStyle: true,
                            padding: 15
                        }
                    }
                }
            }
        });
        
        // Bar Chart
        const barCtx = document.getElementById('barChart').getContext('2d');
        
        new Chart(barCtx, {
            type: 'bar',
            data: {
                labels: ['Hadir', 'Izin', 'Sakit', 'Alpha'],
                datasets: [{
                    label: 'Jumlah',
                    data: [chartData.hadir, chartData.izin, chartData.sakit, chartData.alpha],
                    backgroundColor: ['#22c55e', '#3b82f6', '#eab308', '#ef4444']
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: true,
                plugins: {
                    legend: {
                        display: false
                    }
                },
                scales: {
                    y: {
                        beginAtZero: true,
                        ticks: {
                            font: {
                                family: 'Poppins'
                            }
                        }
                    },
                    x: {
                        ticks: {
                            font: {
                                family: 'Poppins'
                            }
                        }
                    }
                }
            }
        });
    </script>
</body>
</html>
