<?php
session_start();
if (!isset($_SESSION['admin_id'])) {
    header('Location: ../login.php');
    exit();
}

require_once '../config/database.php';
$conn = getConnection();

// Get filter
$filter = $_GET['filter'] ?? 'harian';
$tanggal = $_GET['tanggal'] ?? date('Y-m-d');
$bulan = $_GET['bulan'] ?? date('Y-m');
$guru_id = $_GET['guru_id'] ?? '';
$kelas = $_GET['kelas'] ?? '';

// Get guru list for filter
$guru_list = $conn->query("SELECT id, nama FROM guru ORDER BY nama")->fetch_all(MYSQLI_ASSOC);

// Get kelas list for filter
$kelas_list = $conn->query("SELECT DISTINCT kelas FROM siswa WHERE kelas IS NOT NULL AND kelas != '' ORDER BY kelas")->fetch_all(MYSQLI_ASSOC);

// Prepare query based on filter
if ($filter == 'harian') {
    $where = "WHERE DATE(a.tanggal) = '$tanggal'";
    $title = "Statistik Harian - " . date('d F Y', strtotime($tanggal));
} elseif ($filter == 'mingguan') {
    $start_week = date('Y-m-d', strtotime('monday this week', strtotime($tanggal)));
    $end_week = date('Y-m-d', strtotime('sunday this week', strtotime($tanggal)));
    $where = "WHERE a.tanggal BETWEEN '$start_week' AND '$end_week'";
    $title = "Statistik Mingguan - " . date('d M', strtotime($start_week)) . " s/d " . date('d M Y', strtotime($end_week));
} else { // bulanan
    $start_month = $bulan . '-01';
    $end_month = date('Y-m-t', strtotime($start_month));
    $where = "WHERE a.tanggal BETWEEN '$start_month' AND '$end_month'";
    $title = "Statistik Bulanan - " . date('F Y', strtotime($start_month));
}

if ($guru_id) {
    $where .= " AND a.guru_id = $guru_id";
}

if ($kelas) {
    $where .= " AND s.kelas = '$kelas'";
}

// Get summary statistics
$stats = $conn->query("
    SELECT 
        COUNT(DISTINCT a.siswa_id) as total_siswa,
        SUM(CASE WHEN a.status='hadir' THEN 1 ELSE 0 END) as total_hadir,
        SUM(CASE WHEN a.status='izin' THEN 1 ELSE 0 END) as total_izin,
        SUM(CASE WHEN a.status='sakit' THEN 1 ELSE 0 END) as total_sakit,
        SUM(CASE WHEN a.status='alpha' THEN 1 ELSE 0 END) as total_alpha
    FROM absensi a
    JOIN siswa s ON a.siswa_id = s.id
    $where
")->fetch_assoc();

// Get data for pie chart
$chart_data = [
    'hadir' => $stats['total_hadir'] ?? 0,
    'izin' => $stats['total_izin'] ?? 0,
    'sakit' => $stats['total_sakit'] ?? 0,
    'alpha' => $stats['total_alpha'] ?? 0
];

$conn->close();
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Statistik - SIPANCUR MOBILE</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Poppins', sans-serif;
            background: #f3f4f6;
            display: flex;
            min-height: 100vh;
        }
        
        /* Sidebar */
        .sidebar {
            width: 280px;
            background: white;
            box-shadow: 2px 0 10px rgba(0,0,0,0.08);
            position: fixed;
            left: 0;
            top: 0;
            bottom: 0;
            z-index: 1000;
            display: flex;
            flex-direction: column;
        }
        
        .sidebar-header {
            padding: 30px 25px;
            background: linear-gradient(135deg, #4ade80 0%, #22c55e 100%);
            color: white;
        }
        
        .sidebar-logo {
            display: flex;
            align-items: center;
            gap: 15px;
        }
        
        .sidebar-logo img {
            width: 50px;
            height: 50px;
            border-radius: 12px;
            border: 2px solid rgba(255,255,255,0.3);
            box-shadow: 0 4px 10px rgba(0,0,0,0.1);
        }
        
        .sidebar-logo-text h1 {
            font-size: 20px;
            font-weight: 700;
            margin-bottom: 2px;
        }
        
        .sidebar-logo-text p {
            font-size: 11px;
            opacity: 0.9;
            font-weight: 400;
        }
        
        .sidebar-user {
            padding: 25px;
            border-bottom: 1px solid #e5e7eb;
            background: #f9fafb;
        }
        
        .user-info {
            display: flex;
            align-items: center;
            gap: 15px;
        }
        
        .user-avatar {
            width: 50px;
            height: 50px;
            background: linear-gradient(135deg, #4ade80 0%, #22c55e 100%);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 20px;
            font-weight: 700;
            box-shadow: 0 4px 12px rgba(74, 222, 128, 0.3);
            flex-shrink: 0;
        }
        
        .user-details {
            flex: 1;
            min-width: 0;
        }
        
        .user-details h3 {
            font-size: 15px;
            font-weight: 600;
            color: #1f2937;
            margin: 0 0 3px 0;
            line-height: 1.2;
        }
        
        .user-details p {
            font-size: 12px;
            color: #6b7280;
            font-weight: 500;
            margin: 0;
            line-height: 1.2;
        }
        
        .sidebar-menu {
            flex: 1;
            padding: 25px 0;
            overflow-y: auto;
        }
        
        .menu-section {
            margin-bottom: 30px;
        }
        
        .menu-title {
            padding: 0 25px;
            font-size: 11px;
            font-weight: 700;
            color: #9ca3af;
            text-transform: uppercase;
            letter-spacing: 1px;
            margin-bottom: 10px;
        }
        
        .menu-item {
            display: flex;
            align-items: center;
            gap: 15px;
            padding: 14px 25px;
            margin: 0 15px;
            color: #6b7280;
            text-decoration: none;
            transition: all 0.3s;
            position: relative;
            border-radius: 10px;
        }
        
        .menu-item:hover {
            background: #f3f4f6;
            color: #22c55e;
        }
        
        .menu-item.active {
            background: linear-gradient(135deg, rgba(74, 222, 128, 0.15) 0%, rgba(34, 197, 94, 0.15) 100%);
            color: #22c55e;
            font-weight: 600;
        }
        
        .menu-item.active::before {
            content: '';
            position: absolute;
            left: -15px;
            top: 50%;
            transform: translateY(-50%);
            width: 4px;
            height: 70%;
            background: #22c55e;
            border-radius: 0 4px 4px 0;
        }
        
        .menu-item i {
            width: 22px;
            font-size: 20px;
            text-align: center;
        }
        
        .menu-item span {
            font-size: 14px;
            font-weight: 500;
        }
        
        .sidebar-footer {
            padding: 25px;
            border-top: 1px solid #e5e7eb;
            background: #f9fafb;
        }
        
        .btn-logout {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 10px;
            width: 100%;
            padding: 14px;
            background: linear-gradient(135deg, #f87171 0%, #ef4444 100%);
            color: white;
            text-decoration: none;
            border-radius: 12px;
            font-size: 14px;
            font-weight: 600;
            transition: all 0.3s;
            box-shadow: 0 4px 12px rgba(239, 68, 68, 0.2);
        }
        
        .btn-logout:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(239, 68, 68, 0.3);
        }
        
        .btn-logout:active {
            transform: translateY(0);
        }
        
        /* Main Content */
        .main-content {
            margin-left: 280px;
            flex: 1;
            padding: 30px;
        }
        
        .page-header {
            margin-bottom: 30px;
        }
        
        .page-header h2 {
            font-size: 28px;
            font-weight: 700;
            color: #1f2937;
            display: flex;
            align-items: center;
            gap: 12px;
        }
        
        .filter-card {
            background: white;
            border-radius: 15px;
            padding: 25px;
            margin-bottom: 30px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.05);
        }
        
        .filter-card h3 {
            color: #1f2937;
            font-size: 18px;
            margin-bottom: 20px;
            font-weight: 600;
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        .filter-form {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 15px;
            align-items: end;
        }
        
        .form-group {
            display: flex;
            flex-direction: column;
            gap: 8px;
        }
        
        .form-group label {
            font-size: 13px;
            color: #6b7280;
            font-weight: 500;
        }
        
        .form-group input,
        .form-group select {
            padding: 12px;
            border: 1px solid #e5e7eb;
            border-radius: 10px;
            font-family: 'Poppins', sans-serif;
            font-size: 14px;
            transition: all 0.3s;
        }
        
        .form-group input:focus,
        .form-group select:focus {
            outline: none;
            border-color: #22c55e;
            box-shadow: 0 0 0 3px rgba(74, 222, 128, 0.1);
        }
        
        .btn-filter {
            background: linear-gradient(135deg, #4ade80 0%, #22c55e 100%);
            color: white;
            padding: 12px 24px;
            border: none;
            border-radius: 10px;
            cursor: pointer;
            font-weight: 600;
            font-family: 'Poppins', sans-serif;
            font-size: 14px;
            display: flex;
            align-items: center;
            gap: 8px;
            justify-content: center;
        }
        
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }
        
        .stat-card {
            background: white;
            border-radius: 15px;
            padding: 25px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.05);
            transition: all 0.3s;
        }
        
        .stat-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 25px rgba(0,0,0,0.1);
        }
        
        .stat-card .icon {
            width: 50px;
            height: 50px;
            border-radius: 10px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 24px;
            margin-bottom: 15px;
        }
        
        .stat-card.green .icon {
            background: rgba(74, 222, 128, 0.1);
            color: #22c55e;
        }
        
        .stat-card.blue .icon {
            background: rgba(59, 130, 246, 0.1);
            color: #3b82f6;
        }
        
        .stat-card.yellow .icon {
            background: rgba(234, 179, 8, 0.1);
            color: #eab308;
        }
        
        .stat-card.red .icon {
            background: rgba(239, 68, 68, 0.1);
            color: #ef4444;
        }
        
        .stat-card .label {
            color: #6b7280;
            font-size: 13px;
            margin-bottom: 5px;
            font-weight: 500;
        }
        
        .stat-card .value {
            color: #1f2937;
            font-size: 32px;
            font-weight: 700;
        }
        
        .chart-grid {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 20px;
            margin-bottom: 30px;
        }
        
        .chart-card {
            background: white;
            border-radius: 15px;
            padding: 25px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.05);
        }
        
        .chart-card h3 {
            color: #1f2937;
            font-size: 18px;
            margin-bottom: 20px;
            font-weight: 600;
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        @media (max-width: 768px) {
            .sidebar {
                width: 75px;
            }
            
            .sidebar-logo-text,
            .sidebar-user,
            .menu-title,
            .menu-item span,
            .btn-logout span {
                display: none;
            }
            
            .sidebar-header {
                padding: 25px 12px;
            }
            
            .sidebar-logo {
                justify-content: center;
            }
            
            .sidebar-logo img {
                width: 45px;
                height: 45px;
            }
            
            .menu-item {
                justify-content: center;
                margin: 8px;
                padding: 16px 0;
            }
            
            .menu-item.active::before {
                left: -8px;
                height: 100%;
            }
            
            .menu-item i {
                width: auto;
                font-size: 22px;
            }
            
            .btn-logout {
                padding: 16px 10px;
                justify-content: center;
            }
            
            .main-content {
                margin-left: 75px;
                padding: 20px;
            }
            
            .filter-form {
                grid-template-columns: 1fr;
            }
            
            .stats-grid {
                grid-template-columns: 1fr;
            }
            
            .chart-grid {
                grid-template-columns: 1fr;
            }
        }
    </style>
</head>
<body>
    <!-- Sidebar -->
    <div class="sidebar">
        <div class="sidebar-header">
            <div class="sidebar-logo">
                <img src="../logo.png" alt="Logo">
                <div class="sidebar-logo-text">
                    <h1>SIPANCUR</h1>
                    <p>SMAN 1 AJIBARANG</p>
                </div>
            </div>
        </div>
        
        <div class="sidebar-user">
            <div class="user-info">
                <div class="user-avatar">A</div>
                <div class="user-details">
                    <h3>Administrator</h3>
                    <p>Super Admin</p>
                </div>
            </div>
        </div>
        
        <div class="sidebar-menu">
            <div class="menu-section">
                <div class="menu-title">Menu Utama</div>
                <a href="dashboard.php" class="menu-item">
                    <i class="fas fa-home"></i>
                    <span>Dashboard</span>
                </a>
                <a href="guru.php" class="menu-item">
                    <i class="fas fa-users"></i>
                    <span>Kelola Guru</span>
                </a>
                <a href="siswa.php" class="menu-item">
                    <i class="fas fa-user-graduate"></i>
                    <span>Data Siswa</span>
                </a>
                <a href="reporting.php" class="menu-item">
                    <i class="fas fa-chart-bar"></i>
                    <span>Reporting</span>
                </a>
                <a href="statistik.php" class="menu-item active">
                    <i class="fas fa-chart-pie"></i>
                    <span>Statistik</span>
                </a>
                <a href="pengaturan.php" class="menu-item">
                    <i class="fas fa-cog"></i>
                    <span>Pengaturan</span>
                </a>
            </div>
        </div>
        
        <div class="sidebar-footer">
            <a href="../logout.php" class="btn-logout">
                <i class="fas fa-sign-out-alt"></i>
                <span>Keluar</span>
            </a>
        </div>
    </div>
    
    <!-- Main Content -->
    <div class="main-content">
        <div class="page-header">
            <h2><i class="fas fa-chart-pie"></i> Statistik Kehadiran</h2>
        </div>
        
        <div class="filter-card">
            <h3><i class="fas fa-filter"></i> Filter Statistik</h3>
            <form method="GET" class="filter-form">
                <div class="form-group">
                    <label>Tipe Laporan</label>
                    <select name="filter" id="filterType" onchange="updateDateInput()">
                        <option value="harian" <?php echo $filter == 'harian' ? 'selected' : ''; ?>>Harian</option>
                        <option value="mingguan" <?php echo $filter == 'mingguan' ? 'selected' : ''; ?>>Mingguan</option>
                        <option value="bulanan" <?php echo $filter == 'bulanan' ? 'selected' : ''; ?>>Bulanan</option>
                    </select>
                </div>
                
                <div class="form-group" id="tanggalGroup">
                    <label>Tanggal</label>
                    <input type="date" name="tanggal" value="<?php echo $tanggal; ?>">
                </div>
                
                <div class="form-group" id="bulanGroup" style="display: none;">
                    <label>Bulan</label>
                    <input type="month" name="bulan" value="<?php echo $bulan; ?>">
                </div>
                
                <div class="form-group">
                    <label>Guru</label>
                    <select name="guru_id">
                        <option value="">Semua Guru</option>
                        <?php foreach ($guru_list as $guru): ?>
                            <option value="<?php echo $guru['id']; ?>" <?php echo $guru_id == $guru['id'] ? 'selected' : ''; ?>>
                                <?php echo $guru['nama']; ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                
                <div class="form-group">
                    <label>Kelas</label>
                    <select name="kelas">
                        <option value="">Semua Kelas</option>
                        <?php foreach ($kelas_list as $k): ?>
                            <option value="<?php echo $k['kelas']; ?>" <?php echo $kelas == $k['kelas'] ? 'selected' : ''; ?>>
                                <?php echo $k['kelas']; ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                
                <div class="form-group">
                    <button type="submit" class="btn-filter">
                        <i class="fas fa-search"></i> Tampilkan
                    </button>
                </div>
            </form>
        </div>
        
        <div class="stats-grid">
            <div class="stat-card green">
                <div class="icon"><i class="fas fa-check-circle"></i></div>
                <div class="label">Hadir</div>
                <div class="value"><?php echo $stats['total_hadir'] ?? 0; ?></div>
            </div>
            
            <div class="stat-card blue">
                <div class="icon"><i class="fas fa-envelope"></i></div>
                <div class="label">Izin</div>
                <div class="value"><?php echo $stats['total_izin'] ?? 0; ?></div>
            </div>
            
            <div class="stat-card yellow">
                <div class="icon"><i class="fas fa-medkit"></i></div>
                <div class="label">Sakit</div>
                <div class="value"><?php echo $stats['total_sakit'] ?? 0; ?></div>
            </div>
            
            <div class="stat-card red">
                <div class="icon"><i class="fas fa-times-circle"></i></div>
                <div class="label">Alpha</div>
                <div class="value"><?php echo $stats['total_alpha'] ?? 0; ?></div>
            </div>
        </div>
        
        <div class="chart-grid">
            <div class="chart-card">
                <h3><i class="fas fa-chart-pie"></i> Persentase Kehadiran</h3>
                <canvas id="pieChart"></canvas>
            </div>
            
            <div class="chart-card">
                <h3><i class="fas fa-chart-bar"></i> Grafik Kehadiran</h3>
                <canvas id="barChart"></canvas>
            </div>
        </div>
    </div>
    
    <script>
        function updateDateInput() {
            const filterType = document.getElementById('filterType').value;
            const tanggalGroup = document.getElementById('tanggalGroup');
            const bulanGroup = document.getElementById('bulanGroup');
            
            if (filterType === 'bulanan') {
                tanggalGroup.style.display = 'none';
                bulanGroup.style.display = 'block';
            } else {
                tanggalGroup.style.display = 'block';
                bulanGroup.style.display = 'none';
            }
        }
        
        updateDateInput();
        
        // Pie Chart
        const pieCtx = document.getElementById('pieChart').getContext('2d');
        const chartData = <?php echo json_encode($chart_data); ?>;
        
        new Chart(pieCtx, {
            type: 'doughnut',
            data: {
                labels: ['Hadir', 'Izin', 'Sakit', 'Alpha'],
                datasets: [{
                    data: [chartData.hadir, chartData.izin, chartData.sakit, chartData.alpha],
                    backgroundColor: ['#22c55e', '#3b82f6', '#eab308', '#ef4444']
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: true,
                plugins: {
                    legend: {
                        position: 'bottom',
                        labels: {
                            font: {
                                family: 'Poppins',
                                size: 12
                            },
                            usePointStyle: true,
                            padding: 15
                        }
                    }
                }
            }
        });
        
        // Bar Chart
        const barCtx = document.getElementById('barChart').getContext('2d');
        
        new Chart(barCtx, {
            type: 'bar',
            data: {
                labels: ['Hadir', 'Izin', 'Sakit', 'Alpha'],
                datasets: [{
                    label: 'Jumlah',
                    data: [chartData.hadir, chartData.izin, chartData.sakit, chartData.alpha],
                    backgroundColor: ['#22c55e', '#3b82f6', '#eab308', '#ef4444']
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: true,
                plugins: {
                    legend: {
                        display: false
                    }
                },
                scales: {
                    y: {
                        beginAtZero: true,
                        ticks: {
                            font: {
                                family: 'Poppins'
                            }
                        }
                    },
                    x: {
                        ticks: {
                            font: {
                                family: 'Poppins'
                            }
                        }
                    }
                }
            }
        });
    </script>
</body>
</html>
