<?php
session_start();
if (!isset($_SESSION['guru_id'])) {
    header('Location: ../login.php');
    exit();
}

require_once '../config/database.php';
$conn = getConnection();

$guru_id = $_SESSION['guru_id'];

// Get statistics
$total_siswa = $conn->query("SELECT COUNT(*) as count FROM siswa WHERE guru_id=$guru_id AND status='aktif'")->fetch_assoc()['count'];
$today = date('Y-m-d');
$total_hadir_today = $conn->query("SELECT COUNT(*) as count FROM absensi WHERE guru_id=$guru_id AND tanggal='$today' AND status='hadir'")->fetch_assoc()['count'];
$total_izin_today = $conn->query("SELECT COUNT(*) as count FROM absensi WHERE guru_id=$guru_id AND tanggal='$today' AND status='izin'")->fetch_assoc()['count'];
$total_sakit_today = $conn->query("SELECT COUNT(*) as count FROM absensi WHERE guru_id=$guru_id AND tanggal='$today' AND status='sakit'")->fetch_assoc()['count'];
$total_alpha_today = $conn->query("SELECT COUNT(*) as count FROM absensi WHERE guru_id=$guru_id AND tanggal='$today' AND status='alpha'")->fetch_assoc()['count'];

// Get data for chart (last 7 days)
$chart_data = [];
for ($i = 6; $i >= 0; $i--) {
    $date = date('Y-m-d', strtotime("-$i days"));
    $result = $conn->query("
        SELECT 
            SUM(CASE WHEN status='hadir' THEN 1 ELSE 0 END) as hadir,
            SUM(CASE WHEN status='alpha' THEN 1 ELSE 0 END) as alpha
        FROM absensi WHERE guru_id=$guru_id AND tanggal='$date'
    ")->fetch_assoc();
    
    $chart_data[] = [
        'date' => date('d M', strtotime($date)),
        'hadir' => $result['hadir'] ?? 0,
        'alpha' => $result['alpha'] ?? 0
    ];
}

$conn->close();
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Dashboard Guru - SIPANCUR MOBILE</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Poppins', sans-serif;
            background: #f3f4f6;
            padding-bottom: 80px;
        }
        
        .header {
            background: linear-gradient(135deg, #4ade80 0%, #22c55e 100%);
            color: white;
            padding: 20px;
            box-shadow: 0 2px 15px rgba(0,0,0,0.1);
            position: sticky;
            top: 0;
            z-index: 100;
        }
        
        .header-content {
            display: flex;
            align-items: center;
            gap: 15px;
        }
        
        .header-content img {
            width: 50px;
            height: 50px;
            object-fit: contain;
            background: white;
            border-radius: 12px;
            padding: 5px;
        }
        
        .header-info h1 {
            font-size: 20px;
            font-weight: 700;
            margin-bottom: 3px;
        }
        
        .header-info p {
            font-size: 13px;
            opacity: 0.95;
        }
        
        .container {
            padding: 20px;
            max-width: 600px;
            margin: 0 auto;
        }
        
        .welcome-card {
            background: linear-gradient(135deg, #4ade80 0%, #22c55e 100%);
            color: white;
            border-radius: 20px;
            padding: 30px 25px;
            margin-bottom: 20px;
            box-shadow: 0 8px 25px rgba(74, 222, 128, 0.3);
        }
        
        .welcome-card h2 {
            font-size: 28px;
            margin-bottom: 8px;
            font-weight: 700;
        }
        
        .welcome-card p {
            font-size: 16px;
            opacity: 0.95;
            margin-bottom: 5px;
        }
        
        .welcome-card .date {
            font-size: 13px;
            opacity: 0.85;
        }
        
        .quick-stats {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 15px;
            margin-bottom: 25px;
        }
        
        .quick-stat {
            background: white;
            border-radius: 18px;
            padding: 20px;
            box-shadow: 0 4px 15px rgba(0,0,0,0.08);
            display: flex;
            align-items: center;
            gap: 15px;
        }
        
        .stat-icon {
            width: 55px;
            height: 55px;
            border-radius: 14px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 26px;
        }
        
        .stat-icon.green {
            background: rgba(34, 197, 94, 0.12);
            color: #22c55e;
        }
        
        .stat-icon.blue {
            background: rgba(59, 130, 246, 0.12);
            color: #3b82f6;
        }
        
        .stat-info {
            flex: 1;
        }
        
        .stat-value {
            color: #1f2937;
            font-size: 28px;
            font-weight: 700;
            line-height: 1;
            margin-bottom: 5px;
        }
        
        .stat-label {
            color: #6b7280;
            font-size: 12px;
            font-weight: 500;
        }
        
        .section-title {
            margin-bottom: 15px;
        }
        
        .section-title h3 {
            color: #1f2937;
            font-size: 18px;
            font-weight: 600;
        }
        
        .main-menu-grid {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 15px;
            margin-bottom: 20px;
        }
        
        .main-menu-item {
            position: relative;
            border-radius: 20px;
            padding: 30px 20px;
            text-align: center;
            text-decoration: none;
            color: white;
            box-shadow: 0 8px 20px rgba(0,0,0,0.15);
            transition: all 0.3s;
            overflow: hidden;
            min-height: 140px;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            gap: 12px;
        }
        
        .main-menu-item:active {
            transform: scale(0.95);
        }
        
        .menu-icon {
            font-size: 48px;
            margin-bottom: 5px;
        }
        
        .menu-label {
            font-size: 15px;
            font-weight: 600;
            line-height: 1.3;
        }
        
        .badge-soon {
            position: absolute;
            top: 10px;
            right: 10px;
            background: rgba(255, 255, 255, 0.25);
            backdrop-filter: blur(10px);
            padding: 4px 12px;
            border-radius: 20px;
            font-size: 10px;
            font-weight: 700;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        .btn-logout {
            display: block;
            width: calc(100% - 40px);
            max-width: 400px;
            margin: 20px auto 0;
            padding: 14px 20px;
            background: linear-gradient(135deg, #f87171 0%, #ef4444 100%);
            color: white;
            text-decoration: none;
            border-radius: 12px;
            font-size: 15px;
            font-weight: 600;
            text-align: center;
            box-shadow: 0 4px 15px rgba(239, 68, 68, 0.3);
            transition: all 0.3s;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 10px;
        }
        
        .btn-logout:active {
            transform: scale(0.98);
        }
        
        .bottom-nav {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            background: white;
            box-shadow: 0 -2px 15px rgba(0,0,0,0.1);
            padding: 12px 20px;
            display: flex;
            justify-content: space-around;
            z-index: 100;
        }
        
        .nav-item {
            display: flex;
            flex-direction: column;
            align-items: center;
            gap: 5px;
            text-decoration: none;
            color: #9ca3af;
            transition: all 0.3s;
            padding: 8px 15px;
            border-radius: 12px;
            flex: 1;
            max-width: 80px;
        }
        
        .nav-item.active {
            color: #22c55e;
            background: rgba(74, 222, 128, 0.1);
        }
        
        .nav-item i {
            font-size: 22px;
        }
        
        .nav-item span {
            font-size: 11px;
            font-weight: 500;
        }
        
        @media (max-width: 400px) {
            .stats-grid {
                grid-template-columns: 1fr;
            }
            
            .stat-card .value {
                font-size: 24px;
            }
        }
    </style>
</head>
<body>
    <div class="header">
        <div class="header-content">
            <img src="../logo.png" alt="Logo">
            <div class="header-info">
                <h1>SIPANCUR MOBILE</h1>
                <p>Halo, <?php echo $_SESSION['guru_nama']; ?>! 👋</p>
            </div>
        </div>
    </div>
    
    <div class="container">
        <div class="welcome-card">
            <h2>Selamat Datang!</h2>
            <p><?php echo $_SESSION['guru_nama']; ?></p>
            <div class="date"><?php echo date('l, d F Y'); ?></div>
        </div>
        
        <div class="quick-stats">
            <div class="quick-stat">
                <div class="stat-icon green">
                    <i class="fas fa-check-circle"></i>
                </div>
                <div class="stat-info">
                    <div class="stat-value"><?php echo $total_hadir_today; ?></div>
                    <div class="stat-label">Hadir Hari Ini</div>
                </div>
            </div>
            <div class="quick-stat">
                <div class="stat-icon blue">
                    <i class="fas fa-user-graduate"></i>
                </div>
                <div class="stat-info">
                    <div class="stat-value"><?php echo $total_siswa; ?></div>
                    <div class="stat-label">Total Siswa</div>
                </div>
            </div>
        </div>
        
        <div class="section-title">
            <h3>Menu Utama</h3>
        </div>
        
        <div class="main-menu-grid">
            <a href="presensi.php" class="main-menu-item" style="background: linear-gradient(135deg, #4ade80 0%, #22c55e 100%);">
                <div class="menu-icon">
                    <i class="fas fa-clipboard-check"></i>
                </div>
                <div class="menu-label">Presensi Siswa</div>
            </a>
            
            <a href="siswa.php" class="main-menu-item" style="background: linear-gradient(135deg, #60a5fa 0%, #3b82f6 100%);">
                <div class="menu-icon">
                    <i class="fas fa-users"></i>
                </div>
                <div class="menu-label">Data Siswa</div>
            </a>
            
            <a href="reporting.php" class="main-menu-item" style="background: linear-gradient(135deg, #c084fc 0%, #a855f7 100%);">
                <div class="menu-icon">
                    <i class="fas fa-chart-bar"></i>
                </div>
                <div class="menu-label">Laporan</div>
            </a>
            
            <a href="pengaturan.php" class="main-menu-item" style="background: linear-gradient(135deg, #fbbf24 0%, #f59e0b 100%);">
                <div class="menu-icon">
                    <i class="fas fa-cog"></i>
                </div>
                <div class="menu-label">Pengaturan</div>
            </a>
        </div>
        
        <a href="../logout.php" class="btn-logout">
            <i class="fas fa-sign-out-alt"></i> Keluar
        </a>
    </div>
    
    <div class="bottom-nav">
        <a href="dashboard.php" class="nav-item active">
            <i class="fas fa-home"></i>
            <span>Home</span>
        </a>
        <a href="presensi.php" class="nav-item">
            <i class="fas fa-clipboard-check"></i>
            <span>Presensi</span>
        </a>
        <a href="siswa.php" class="nav-item">
            <i class="fas fa-users"></i>
            <span>Siswa</span>
        </a>
        <a href="reporting.php" class="nav-item">
            <i class="fas fa-chart-bar"></i>
            <span>Laporan</span>
        </a>
    </div>
</body>
</html>
