<?php
session_start();
if (!isset($_SESSION['guru_id'])) {
    header('Location: ../login.php');
    exit();
}

require_once '../config/database.php';
$conn = getConnection();

$guru_id = $_SESSION['guru_id'];
$success = '';
$error = '';

// Get guru data
$guru = $conn->query("SELECT * FROM guru WHERE id=$guru_id")->fetch_assoc();

// Get statistics
$total_siswa = $conn->query("SELECT COUNT(*) as total FROM siswa WHERE guru_id=$guru_id AND status='aktif'")->fetch_assoc()['total'];

$bulan_ini = date('Y-m');
$total_presensi_bulan = $conn->query("
    SELECT COUNT(*) as total 
    FROM absensi 
    WHERE guru_id=$guru_id 
    AND DATE_FORMAT(tanggal, '%Y-%m') = '$bulan_ini'
")->fetch_assoc()['total'];

$total_hadir_bulan = $conn->query("
    SELECT COUNT(*) as total 
    FROM absensi 
    WHERE guru_id=$guru_id 
    AND status='Hadir'
    AND DATE_FORMAT(tanggal, '%Y-%m') = '$bulan_ini'
")->fetch_assoc()['total'];

$persentase_bulan = $total_presensi_bulan > 0 ? round(($total_hadir_bulan / $total_presensi_bulan) * 100, 1) : 0;

// Handle update profil
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['update_profil'])) {
    $nama = $_POST['nama'];
    $email = $_POST['email'];
    $telepon = $_POST['telepon'];
    $alamat = $_POST['alamat'];
    
    $stmt = $conn->prepare("UPDATE guru SET nama=?, email=?, telepon=?, alamat=? WHERE id=?");
    $stmt->bind_param("ssssi", $nama, $email, $telepon, $alamat, $guru_id);
    
    if ($stmt->execute()) {
        $success = "Profil berhasil diupdate!";
        $guru = $conn->query("SELECT * FROM guru WHERE id=$guru_id")->fetch_assoc();
    } else {
        $error = "Gagal update profil!";
    }
    $stmt->close();
}

// Handle update password
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['update_password'])) {
    $password_lama = $_POST['password_lama'];
    $password_baru = $_POST['password_baru'];
    $password_konfirmasi = $_POST['password_konfirmasi'];
    
    if (password_verify($password_lama, $guru['password'])) {
        if ($password_baru === $password_konfirmasi) {
            $password_hash = password_hash($password_baru, PASSWORD_DEFAULT);
            $stmt = $conn->prepare("UPDATE guru SET password=? WHERE id=?");
            $stmt->bind_param("si", $password_hash, $guru_id);
            
            if ($stmt->execute()) {
                $success = "Password berhasil diubah!";
            } else {
                $error = "Gagal mengubah password!";
            }
            $stmt->close();
        } else {
            $error = "Password baru dan konfirmasi tidak cocok!";
        }
    } else {
        $error = "Password lama salah!";
    }
}

// Handle upload foto
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_FILES['foto'])) {
    $foto = $_FILES['foto'];
    
    if ($foto['error'] == 0) {
        $allowed = ['jpg', 'jpeg', 'png', 'gif'];
        $filename = $foto['name'];
        $ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
        
        if (in_array($ext, $allowed)) {
            $new_filename = 'guru_' . $guru_id . '_' . time() . '.' . $ext;
            $upload_path = '../uploads/guru/' . $new_filename;
            
            // Create directory if not exists
            if (!file_exists('../uploads/guru/')) {
                mkdir('../uploads/guru/', 0777, true);
            }
            
            if (move_uploaded_file($foto['tmp_name'], $upload_path)) {
                // Delete old photo
                if ($guru['foto'] && file_exists('../' . $guru['foto'])) {
                    unlink('../' . $guru['foto']);
                }
                
                $foto_path = 'uploads/guru/' . $new_filename;
                $stmt = $conn->prepare("UPDATE guru SET foto=? WHERE id=?");
                $stmt->bind_param("si", $foto_path, $guru_id);
                
                if ($stmt->execute()) {
                    $success = "Foto profil berhasil diupdate!";
                    $guru = $conn->query("SELECT * FROM guru WHERE id=$guru_id")->fetch_assoc();
                } else {
                    $error = "Gagal update foto di database!";
                }
                $stmt->close();
            } else {
                $error = "Gagal upload foto!";
            }
        } else {
            $error = "Format file tidak diizinkan! Gunakan JPG, PNG, atau GIF.";
        }
    }
}

$conn->close();
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Pengaturan - SIPANCUR MOBILE</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Poppins', sans-serif;
            background: #f3f4f6;
            padding-bottom: 80px;
        }
        
        .header {
            background: linear-gradient(135deg, #4ade80 0%, #22c55e 100%);
            color: white;
            padding: 20px;
            box-shadow: 0 2px 15px rgba(0,0,0,0.1);
            position: sticky;
            top: 0;
            z-index: 100;
        }
        
        .header-content {
            display: flex;
            align-items: center;
            gap: 15px;
        }
        
        .btn-back {
            width: 40px;
            height: 40px;
            background: rgba(255,255,255,0.2);
            border-radius: 10px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 18px;
            color: white;
            text-decoration: none;
        }
        
        .header-title h1 {
            font-size: 20px;
            font-weight: 700;
        }
        
        .header-title p {
            font-size: 13px;
            opacity: 0.9;
        }
        
        .container {
            padding: 20px;
            max-width: 600px;
            margin: 0 auto;
        }
        
        .alert {
            padding: 15px 18px;
            border-radius: 12px;
            margin-bottom: 20px;
            display: flex;
            align-items: center;
            gap: 10px;
            font-size: 14px;
        }
        
        .alert.success {
            background: #d1fae5;
            color: #065f46;
        }
        
        .alert.error {
            background: #fee2e2;
            color: #991b1b;
        }
        
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 15px;
            margin-bottom: 25px;
        }
        
        .stat-card {
            background: white;
            border-radius: 18px;
            padding: 20px;
            box-shadow: 0 4px 15px rgba(0,0,0,0.08);
        }
        
        .stat-card .icon {
            width: 50px;
            height: 50px;
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 24px;
            margin-bottom: 12px;
        }
        
        .stat-card.green .icon {
            background: linear-gradient(135deg, #4ade80 0%, #22c55e 100%);
            color: white;
        }
        
        .stat-card.blue .icon {
            background: linear-gradient(135deg, #60a5fa 0%, #3b82f6 100%);
            color: white;
        }
        
        .stat-card .label {
            color: #6b7280;
            font-size: 12px;
            font-weight: 500;
            margin-bottom: 5px;
        }
        
        .stat-card .value {
            color: #1f2937;
            font-size: 28px;
            font-weight: 700;
        }
        
        .stat-card .sublabel {
            color: #9ca3af;
            font-size: 11px;
            margin-top: 5px;
        }
        
        .card {
            background: white;
            border-radius: 18px;
            padding: 25px;
            margin-bottom: 20px;
            box-shadow: 0 4px 15px rgba(0,0,0,0.08);
        }
        
        .card h2 {
            color: #1f2937;
            font-size: 18px;
            font-weight: 600;
            margin-bottom: 20px;
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        .card h2 i {
            color: #22c55e;
        }
        
        .profile-photo {
            text-align: center;
            margin-bottom: 25px;
        }
        
        .photo-wrapper {
            width: 120px;
            height: 120px;
            margin: 0 auto 15px;
            position: relative;
        }
        
        .photo-preview {
            width: 120px;
            height: 120px;
            border-radius: 50%;
            object-fit: cover;
            border: 4px solid #22c55e;
            background: #f3f4f6;
        }
        
        .photo-upload {
            position: absolute;
            bottom: 0;
            right: 0;
            width: 40px;
            height: 40px;
            background: #22c55e;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            color: white;
            font-size: 18px;
            border: 3px solid white;
        }
        
        .photo-upload input {
            display: none;
        }
        
        .info-row {
            display: flex;
            padding: 12px 0;
            border-bottom: 1px solid #f3f4f6;
        }
        
        .info-row:last-child {
            border-bottom: none;
        }
        
        .info-row .label {
            width: 100px;
            color: #6b7280;
            font-size: 13px;
            font-weight: 500;
        }
        
        .info-row .value {
            flex: 1;
            color: #1f2937;
            font-size: 14px;
            font-weight: 600;
        }
        
        .form-group {
            margin-bottom: 18px;
        }
        
        .form-group label {
            display: block;
            color: #374151;
            font-weight: 500;
            margin-bottom: 8px;
            font-size: 13px;
        }
        
        .form-group input,
        .form-group textarea {
            width: 100%;
            padding: 12px 15px;
            border: 2px solid #e5e7eb;
            border-radius: 10px;
            font-size: 14px;
            font-family: 'Poppins', sans-serif;
        }
        
        .form-group input:focus,
        .form-group textarea:focus {
            outline: none;
            border-color: #4ade80;
        }
        
        .form-group textarea {
            resize: vertical;
            min-height: 80px;
        }
        
        .btn-submit {
            width: 100%;
            padding: 14px;
            background: linear-gradient(135deg, #4ade80 0%, #22c55e 100%);
            color: white;
            border: none;
            border-radius: 12px;
            font-size: 15px;
            font-weight: 600;
            cursor: pointer;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 10px;
        }
        
        .btn-submit:active {
            transform: scale(0.98);
        }
        
        .btn-danger {
            background: linear-gradient(135deg, #f87171 0%, #ef4444 100%);
        }
        
        .bottom-nav {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            background: white;
            box-shadow: 0 -2px 15px rgba(0,0,0,0.1);
            padding: 12px 20px;
            display: flex;
            justify-content: space-around;
            z-index: 100;
        }
        
        .nav-item {
            display: flex;
            flex-direction: column;
            align-items: center;
            gap: 5px;
            text-decoration: none;
            color: #9ca3af;
            transition: all 0.3s;
            padding: 8px 15px;
            border-radius: 12px;
            flex: 1;
            max-width: 80px;
        }
        
        .nav-item.active {
            color: #22c55e;
            background: rgba(74, 222, 128, 0.1);
        }
        
        .nav-item i {
            font-size: 22px;
        }
        
        .nav-item span {
            font-size: 11px;
            font-weight: 500;
        }
    </style>
</head>
<body>
    <div class="header">
        <div class="header-content">
            <a href="dashboard.php" class="btn-back">
                <i class="fas fa-arrow-left"></i>
            </a>
            <div class="header-title">
                <h1>Pengaturan</h1>
                <p>Kelola profil dan akun Anda</p>
            </div>
        </div>
    </div>
    
    <div class="container">
        <?php if ($success): ?>
        <div class="alert success">
            <i class="fas fa-check-circle"></i>
            <?php echo $success; ?>
        </div>
        <?php endif; ?>
        
        <?php if ($error): ?>
        <div class="alert error">
            <i class="fas fa-exclamation-circle"></i>
            <?php echo $error; ?>
        </div>
        <?php endif; ?>
        
        <!-- Informasi Akun -->
        <div class="stats-grid">
            <div class="stat-card green">
                <div class="icon">
                    <i class="fas fa-users"></i>
                </div>
                <div class="label">Total Siswa</div>
                <div class="value"><?php echo $total_siswa; ?></div>
                <div class="sublabel">Siswa aktif</div>
            </div>
            
            <div class="stat-card blue">
                <div class="icon">
                    <i class="fas fa-clipboard-check"></i>
                </div>
                <div class="label">Presensi Bulan Ini</div>
                <div class="value"><?php echo $total_presensi_bulan; ?></div>
                <div class="sublabel"><?php echo $persentase_bulan; ?>% Kehadiran</div>
            </div>
        </div>
        
        <!-- Info Akun -->
        <div class="card">
            <h2><i class="fas fa-id-card"></i> Informasi Akun</h2>
            
            <div class="info-row">
                <div class="label">NIP</div>
                <div class="value"><?php echo $guru['nip']; ?></div>
            </div>
            
            <div class="info-row">
                <div class="label">Username</div>
                <div class="value"><?php echo $guru['username']; ?></div>
            </div>
            
            <div class="info-row">
                <div class="label">Status</div>
                <div class="value" style="color: #22c55e;">
                    <?php echo ucfirst($guru['status']); ?>
                </div>
            </div>
            
            <div class="info-row">
                <div class="label">Terdaftar</div>
                <div class="value"><?php echo date('d F Y', strtotime($guru['created_at'])); ?></div>
            </div>
        </div>
        
        <!-- Profil Guru -->
        <div class="card">
            <h2><i class="fas fa-user-circle"></i> Profil Guru</h2>
            
            <form method="POST" enctype="multipart/form-data">
                <div class="profile-photo">
                    <div class="photo-wrapper">
                        <img src="<?php echo $guru['foto'] ? '../' . $guru['foto'] : 'https://ui-avatars.com/api/?name=' . urlencode($guru['nama']) . '&size=120&background=22c55e&color=fff'; ?>" 
                             alt="Foto Profil" class="photo-preview" id="photoPreview">
                        <label class="photo-upload">
                            <i class="fas fa-camera"></i>
                            <input type="file" name="foto" accept="image/*" onchange="previewPhoto(event)">
                        </label>
                    </div>
                    <button type="submit" class="btn-submit" style="max-width: 200px; margin: 0 auto;">
                        <i class="fas fa-upload"></i> Upload Foto
                    </button>
                </div>
            </form>
            
            <form method="POST" style="margin-top: 25px;">
                <input type="hidden" name="update_profil" value="1">
                
                <div class="form-group">
                    <label>Nama Lengkap</label>
                    <input type="text" name="nama" value="<?php echo $guru['nama']; ?>" required>
                </div>
                
                <div class="form-group">
                    <label>Email</label>
                    <input type="email" name="email" value="<?php echo $guru['email']; ?>" required>
                </div>
                
                <div class="form-group">
                    <label>Telepon</label>
                    <input type="tel" name="telepon" value="<?php echo $guru['telepon']; ?>" required>
                </div>
                
                <div class="form-group">
                    <label>Alamat</label>
                    <textarea name="alamat" required><?php echo $guru['alamat']; ?></textarea>
                </div>
                
                <button type="submit" class="btn-submit">
                    <i class="fas fa-save"></i> Simpan Perubahan
                </button>
            </form>
        </div>
        
        <!-- Ubah Password -->
        <div class="card">
            <h2><i class="fas fa-lock"></i> Ubah Password</h2>
            
            <form method="POST">
                <input type="hidden" name="update_password" value="1">
                
                <div class="form-group">
                    <label>Password Lama</label>
                    <input type="password" name="password_lama" required>
                </div>
                
                <div class="form-group">
                    <label>Password Baru</label>
                    <input type="password" name="password_baru" required minlength="6">
                </div>
                
                <div class="form-group">
                    <label>Konfirmasi Password Baru</label>
                    <input type="password" name="password_konfirmasi" required minlength="6">
                </div>
                
                <button type="submit" class="btn-submit btn-danger">
                    <i class="fas fa-key"></i> Ubah Password
                </button>
            </form>
        </div>
    </div>
    
    <div class="bottom-nav">
        <a href="dashboard.php" class="nav-item">
            <i class="fas fa-home"></i>
            <span>Beranda</span>
        </a>
        <a href="presensi.php" class="nav-item">
            <i class="fas fa-clipboard-check"></i>
            <span>Presensi</span>
        </a>
        <a href="siswa.php" class="nav-item">
            <i class="fas fa-users"></i>
            <span>Siswa</span>
        </a>
        <a href="pengaturan.php" class="nav-item active">
            <i class="fas fa-cog"></i>
            <span>Pengaturan</span>
        </a>
    </div>
    
    <script>
        function previewPhoto(event) {
            const file = event.target.files[0];
            if (file) {
                const reader = new FileReader();
                reader.onload = function(e) {
                    document.getElementById('photoPreview').src = e.target.result;
                }
                reader.readAsDataURL(file);
            }
        }
    </script>
</body>
</html>
