<?php
session_start();
if (!isset($_SESSION['guru_id'])) {
    header('Location: ../login.php');
    exit();
}

require_once '../config/database.php';
$conn = getConnection();

$guru_id = $_SESSION['guru_id'];
$today = date('Y-m-d');
$selected_date = $_GET['tanggal'] ?? $today;

// Handle submit presensi
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['submit_presensi'])) {
    $tanggal = $_POST['tanggal'];
    $success_count = 0;
    $error_count = 0;
    
    foreach ($_POST['status'] as $siswa_id => $status) {
        $keterangan = $_POST['keterangan'][$siswa_id] ?? '';
        
        // Check if already exists
        $check = $conn->query("SELECT id FROM absensi WHERE siswa_id=$siswa_id AND tanggal='$tanggal'");
        
        if ($check->num_rows > 0) {
            // Update
            $stmt = $conn->prepare("UPDATE absensi SET status=?, keterangan=?, guru_id=? WHERE siswa_id=? AND tanggal=?");
            $stmt->bind_param("ssiss", $status, $keterangan, $guru_id, $siswa_id, $tanggal);
        } else {
            // Insert
            $stmt = $conn->prepare("INSERT INTO absensi (siswa_id, guru_id, tanggal, status, keterangan) VALUES (?, ?, ?, ?, ?)");
            $stmt->bind_param("iisss", $siswa_id, $guru_id, $tanggal, $status, $keterangan);
        }
        
        if ($stmt->execute()) {
            $success_count++;
        } else {
            $error_count++;
        }
        $stmt->close();
    }
    
    if ($success_count > 0) {
        $success = "Presensi berhasil disimpan untuk $success_count siswa!";
    }
    if ($error_count > 0) {
        $error = "Gagal menyimpan presensi untuk $error_count siswa!";
    }
}

// Handle edit absensi
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['action']) && $_POST['action'] == 'edit_absensi') {
    $siswa_id = $_POST['siswa_id'];
    $tanggal = $_POST['tanggal'];
    $status = $_POST['status'];
    $keterangan = $_POST['keterangan'] ?? '';
    
    $stmt = $conn->prepare("UPDATE absensi SET status=?, keterangan=? WHERE siswa_id=? AND tanggal=? AND guru_id=?");
    $stmt->bind_param("ssisi", $status, $keterangan, $siswa_id, $tanggal, $guru_id);
    
    if ($stmt->execute()) {
        $_SESSION['success'] = "Absensi berhasil diupdate!";
        header("Location: presensi.php?tanggal=" . $tanggal);
        exit();
    } else {
        $error = "Gagal mengupdate absensi!";
    }
    $stmt->close();
}

// Get success message from session
if (isset($_SESSION['success'])) {
    $success = $_SESSION['success'];
    unset($_SESSION['success']);
}

// Get siswa list (exclude yang sudah diabsen hari ini)
$siswa_list = $conn->query("
    SELECT s.* 
    FROM siswa s
    WHERE s.guru_id=$guru_id 
    AND s.status='aktif'
    AND s.id NOT IN (
        SELECT siswa_id 
        FROM absensi 
        WHERE tanggal='$selected_date' 
        AND guru_id=$guru_id
    )
    ORDER BY s.nama ASC
")->fetch_all(MYSQLI_ASSOC);

// Get siswa yang sudah diabsen untuk ditampilkan
$siswa_diabsen = $conn->query("
    SELECT s.id as siswa_id, s.nama, s.nis, s.kelas, a.status, a.keterangan, a.created_at
    FROM siswa s
    JOIN absensi a ON s.id = a.siswa_id
    WHERE a.guru_id=$guru_id 
    AND a.tanggal='$selected_date'
    ORDER BY a.created_at DESC
")->fetch_all(MYSQLI_ASSOC);

// Get existing presensi for selected date (not used anymore since we filter above)
$presensi_data = [];

$conn->close();
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Presensi Siswa - SIPANCUR MOBILE</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Poppins', sans-serif;
            background: #f3f4f6;
            padding-bottom: 80px;
        }
        
        .header {
            background: linear-gradient(135deg, #4ade80 0%, #22c55e 100%);
            color: white;
            padding: 20px;
            box-shadow: 0 2px 15px rgba(0,0,0,0.1);
            position: sticky;
            top: 0;
            z-index: 100;
        }
        
        .header-content {
            display: flex;
            align-items: center;
            gap: 15px;
        }
        
        .btn-back {
            width: 40px;
            height: 40px;
            background: rgba(255,255,255,0.2);
            border-radius: 10px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 18px;
            color: white;
            text-decoration: none;
        }
        
        .header-title h1 {
            font-size: 20px;
            font-weight: 700;
        }
        
        .header-title p {
            font-size: 13px;
            opacity: 0.9;
        }
        
        .container {
            padding: 20px;
            max-width: 600px;
            margin: 0 auto;
        }
        
        .alert {
            padding: 15px 18px;
            border-radius: 12px;
            margin-bottom: 20px;
            display: flex;
            align-items: center;
            gap: 10px;
            font-size: 14px;
        }
        
        .alert.success {
            background: #d1fae5;
            color: #065f46;
        }
        
        .alert.error {
            background: #fee2e2;
            color: #991b1b;
        }
        
        .date-card {
            background: white;
            border-radius: 18px;
            padding: 20px;
            margin-bottom: 20px;
            box-shadow: 0 4px 15px rgba(0,0,0,0.08);
        }
        
        .date-card label {
            display: block;
            color: #6b7280;
            font-size: 13px;
            font-weight: 500;
            margin-bottom: 10px;
        }
        
        .date-card input {
            width: 100%;
            padding: 14px 18px;
            border: 2px solid #e5e7eb;
            border-radius: 12px;
            font-size: 15px;
            font-family: 'Poppins', sans-serif;
            font-weight: 500;
        }
        
        .date-card input:focus {
            outline: none;
            border-color: #4ade80;
        }
        
        .info-card {
            background: linear-gradient(135deg, #4ade80 0%, #22c55e 100%);
            color: white;
            border-radius: 18px;
            padding: 20px;
            margin-bottom: 20px;
            box-shadow: 0 4px 15px rgba(74, 222, 128, 0.3);
            position: relative;
            display: none;
        }
        
        .info-card.show {
            display: block;
        }
        
        .info-card h3 {
            font-size: 16px;
            margin-bottom: 8px;
            font-weight: 600;
            padding-right: 30px;
        }
        
        .info-card p {
            font-size: 13px;
            opacity: 0.95;
            line-height: 1.6;
        }
        
        .btn-close-info {
            position: absolute;
            top: 15px;
            right: 15px;
            width: 30px;
            height: 30px;
            background: rgba(255, 255, 255, 0.2);
            border: none;
            border-radius: 50%;
            color: white;
            font-size: 16px;
            cursor: pointer;
            display: flex;
            align-items: center;
            justify-content: center;
            transition: all 0.3s;
        }
        
        .btn-close-info:hover {
            background: rgba(255, 255, 255, 0.3);
        }
        
        .btn-close-info:active {
            transform: scale(0.9);
        }
        
        .section-title {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 15px;
            padding: 0 5px;
        }
        
        .section-title h3 {
            color: #1f2937;
            font-size: 17px;
            font-weight: 600;
        }
        
        .section-title .count {
            color: #6b7280;
            font-size: 14px;
            font-weight: 500;
        }
        
        .completed-card {
            background: white;
            border-radius: 18px;
            padding: 20px;
            margin-bottom: 20px;
            box-shadow: 0 4px 15px rgba(0,0,0,0.08);
        }
        
        .completed-card h3 {
            color: #1f2937;
            font-size: 16px;
            margin-bottom: 15px;
            font-weight: 600;
            display: flex;
            align-items: center;
            gap: 8px;
        }
        
        .completed-item {
            display: flex;
            align-items: center;
            gap: 12px;
            padding: 12px;
            background: #f9fafb;
            border-radius: 12px;
            margin-bottom: 10px;
        }
        
        .completed-item:last-child {
            margin-bottom: 0;
        }
        
        .completed-icon {
            width: 40px;
            height: 40px;
            border-radius: 10px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 18px;
        }
        
        .completed-icon.hadir {
            background: rgba(34, 197, 94, 0.12);
            color: #22c55e;
        }
        
        .completed-icon.izin {
            background: rgba(59, 130, 246, 0.12);
            color: #3b82f6;
        }
        
        .completed-icon.sakit {
            background: rgba(234, 179, 8, 0.12);
            color: #eab308;
        }
        
        .completed-icon.alpha {
            background: rgba(239, 68, 68, 0.12);
            color: #ef4444;
        }
        
        .completed-info {
            flex: 1;
        }
        
        .completed-info .name {
            color: #1f2937;
            font-size: 14px;
            font-weight: 600;
            margin-bottom: 3px;
        }
        
        .completed-info .meta {
            color: #6b7280;
            font-size: 11px;
        }
        
        .btn-edit-absen {
            background: #dbeafe;
            color: #1e40af;
            border: none;
            width: 36px;
            height: 36px;
            border-radius: 10px;
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            font-size: 14px;
            transition: all 0.3s;
        }
        
        .btn-edit-absen:active {
            transform: scale(0.9);
            background: #bfdbfe;
        }
        
        .modal {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0,0,0,0.5);
            z-index: 1000;
            overflow-y: auto;
            padding: 20px;
        }
        
        .modal.active {
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .modal-content {
            background: white;
            border-radius: 20px;
            padding: 25px;
            max-width: 500px;
            width: 100%;
            max-height: 90vh;
            overflow-y: auto;
        }
        
        .modal-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
        }
        
        .modal-header h3 {
            color: #1f2937;
            font-size: 18px;
            font-weight: 600;
        }
        
        .btn-close {
            background: #f3f4f6;
            border: none;
            width: 35px;
            height: 35px;
            border-radius: 10px;
            cursor: pointer;
            display: flex;
            align-items: center;
            justify-content: center;
            color: #6b7280;
            font-size: 18px;
        }
        
        .modal-body {
            margin-bottom: 20px;
        }
        
        .student-info-box {
            background: linear-gradient(135deg, #4ade80 0%, #22c55e 100%);
            color: white;
            padding: 18px;
            border-radius: 15px;
            margin-bottom: 20px;
        }
        
        .student-info-box h4 {
            font-size: 17px;
            font-weight: 600;
            margin-bottom: 6px;
        }
        
        .student-info-box p {
            font-size: 13px;
            opacity: 0.9;
        }
        
        .form-group {
            margin-bottom: 18px;
        }
        
        .form-group label {
            display: block;
            color: #374151;
            font-weight: 500;
            margin-bottom: 8px;
            font-size: 13px;
        }
        
        .form-group select,
        .form-group textarea {
            width: 100%;
            padding: 12px 15px;
            border: 2px solid #e5e7eb;
            border-radius: 10px;
            font-size: 14px;
            font-family: 'Poppins', sans-serif;
        }
        
        .form-group select:focus,
        .form-group textarea:focus {
            outline: none;
            border-color: #4ade80;
        }
        
        .form-group textarea {
            resize: vertical;
            min-height: 70px;
        }
        
        .status-options {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 10px;
        }
        
        .status-option {
            display: none;
        }
        
        .status-option-label {
            display: flex;
            flex-direction: column;
            align-items: center;
            gap: 8px;
            padding: 18px 12px;
            border: 2px solid #e5e7eb;
            border-radius: 12px;
            cursor: pointer;
            transition: all 0.3s;
            background: white;
        }
        
        .status-option-label i {
            font-size: 24px;
        }
        
        .status-option-label span {
            font-size: 13px;
            font-weight: 600;
        }
        
        .status-option:checked + .status-option-label {
            border-width: 2px;
        }
        
        .status-option:checked + .status-option-label.hadir {
            border-color: #22c55e;
            background: #d1fae5;
            color: #065f46;
        }
        
        .status-option:checked + .status-option-label.izin {
            border-color: #3b82f6;
            background: #dbeafe;
            color: #1e40af;
        }
        
        .status-option:checked + .status-option-label.sakit {
            border-color: #eab308;
            background: #fef3c7;
            color: #92400e;
        }
        
        .status-option:checked + .status-option-label.alpha {
            border-color: #ef4444;
            background: #fee2e2;
            color: #991b1b;
        }
        
        .modal-footer {
            display: flex;
            gap: 10px;
        }
        
        .btn-secondary {
            flex: 1;
            background: #e5e7eb;
            color: #374151;
            padding: 12px;
            border: none;
            border-radius: 10px;
            cursor: pointer;
            font-size: 14px;
            font-weight: 500;
        }
        
        .btn-primary {
            flex: 1;
            background: linear-gradient(135deg, #4ade80 0%, #22c55e 100%);
            color: white;
            padding: 12px;
            border: none;
            border-radius: 10px;
            cursor: pointer;
            font-size: 14px;
            font-weight: 500;
        }
        
        .btn-primary:active,
        .btn-secondary:active {
            transform: scale(0.98);
        }
        
        .completed-time {
            color: #9ca3af;
            font-size: 11px;
        }
        
        .siswa-item {
            background: white;
            border-radius: 18px;
            padding: 20px;
            margin-bottom: 15px;
            box-shadow: 0 4px 15px rgba(0,0,0,0.08);
        }
        
        .siswa-header {
            display: flex;
            align-items: center;
            gap: 15px;
            margin-bottom: 15px;
        }
        
        .siswa-number {
            width: 45px;
            height: 45px;
            background: linear-gradient(135deg, #4ade80 0%, #22c55e 100%);
            color: white;
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: 700;
            font-size: 16px;
        }
        
        .siswa-info {
            flex: 1;
        }
        
        .siswa-info h4 {
            color: #1f2937;
            font-size: 16px;
            font-weight: 600;
            margin-bottom: 4px;
        }
        
        .siswa-info .meta {
            color: #6b7280;
            font-size: 12px;
            display: flex;
            align-items: center;
            gap: 12px;
        }
        
        .status-buttons {
            display: grid;
            grid-template-columns: repeat(4, 1fr);
            gap: 8px;
            margin-bottom: 12px;
        }
        
        .status-btn {
            padding: 12px 8px;
            border: 2px solid #e5e7eb;
            background: white;
            border-radius: 10px;
            cursor: pointer;
            font-size: 11px;
            font-weight: 600;
            text-align: center;
            transition: all 0.3s;
            display: flex;
            flex-direction: column;
            align-items: center;
            gap: 4px;
        }
        
        .status-btn i {
            font-size: 18px;
        }
        
        .status-btn input {
            display: none;
        }
        
        .status-btn.hadir {
            border-color: #22c55e;
            background: #d1fae5;
            color: #065f46;
        }
        
        .status-btn.izin {
            border-color: #3b82f6;
            background: #dbeafe;
            color: #1e40af;
        }
        
        .status-btn.sakit {
            border-color: #eab308;
            background: #fef3c7;
            color: #92400e;
        }
        
        .status-btn.alpha {
            border-color: #ef4444;
            background: #fee2e2;
            color: #991b1b;
        }
        
        .status-btn:active {
            transform: scale(0.95);
        }
        
        .keterangan-box {
            display: none;
        }
        
        .keterangan-box.show {
            display: block;
        }
        
        .keterangan-box textarea {
            width: 100%;
            padding: 12px;
            border: 2px solid #e5e7eb;
            border-radius: 10px;
            font-size: 13px;
            font-family: 'Poppins', sans-serif;
            resize: vertical;
            min-height: 60px;
        }
        
        .keterangan-box textarea:focus {
            outline: none;
            border-color: #4ade80;
        }
        
        .bottom-nav {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            background: white;
            box-shadow: 0 -2px 15px rgba(0,0,0,0.1);
            padding: 12px 20px;
            display: flex;
            justify-content: space-around;
            z-index: 100;
        }
        
        .nav-item {
            display: flex;
            flex-direction: column;
            align-items: center;
            gap: 5px;
            text-decoration: none;
            color: #9ca3af;
            transition: all 0.3s;
            padding: 8px 15px;
            border-radius: 12px;
            flex: 1;
            max-width: 80px;
        }
        
        .nav-item.active {
            color: #22c55e;
            background: rgba(74, 222, 128, 0.1);
        }
        
        .nav-item i {
            font-size: 22px;
        }
        
        .nav-item span {
            font-size: 11px;
            font-weight: 500;
        }
        
        .empty-state {
            text-align: center;
            padding: 60px 20px;
            color: #9ca3af;
        }
        
        .empty-state i {
            font-size: 64px;
            margin-bottom: 15px;
            opacity: 0.5;
        }
        
        .empty-state p {
            font-size: 14px;
            margin-bottom: 20px;
        }
        
        .btn-link {
            color: #22c55e;
            text-decoration: none;
            font-weight: 600;
        }
        
        .loading-overlay {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(0, 0, 0, 0.7);
            z-index: 9999;
            justify-content: center;
            align-items: center;
        }
        
        .loading-overlay.active {
            display: flex;
        }
        
        .loading-content {
            background: white;
            padding: 30px 40px;
            border-radius: 20px;
            text-align: center;
        }
        
        .loading-spinner {
            width: 50px;
            height: 50px;
            border: 4px solid #e5e7eb;
            border-top: 4px solid #22c55e;
            border-radius: 50%;
            animation: spin 1s linear infinite;
            margin: 0 auto 15px;
        }
        
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        
        .loading-text {
            color: #1f2937;
            font-size: 16px;
            font-weight: 600;
        }
    </style>
</head>
<body>
    <div class="header">
        <div class="header-content">
            <a href="dashboard.php" class="btn-back">
                <i class="fas fa-arrow-left"></i>
            </a>
            <div class="header-title">
                <h1>Presensi Siswa</h1>
                <p>Absensi Harian</p>
            </div>
        </div>
    </div>
    
    <div class="container">
        <?php if (isset($success)): ?>
        <div class="alert success">
            <i class="fas fa-check-circle"></i>
            <span><?php echo $success; ?></span>
        </div>
        <?php endif; ?>
        
        <?php if (isset($error)): ?>
        <div class="alert error">
            <i class="fas fa-exclamation-circle"></i>
            <span><?php echo $error; ?></span>
        </div>
        <?php endif; ?>
        
        <div class="date-card">
            <label><i class="fas fa-calendar"></i> Pilih Tanggal</label>
            <input type="date" id="tanggalInput" value="<?php echo $selected_date; ?>" onchange="changeTanggal()">
        </div>
        
        <div class="info-card" id="infoCard">
            <button class="btn-close-info" onclick="closeInfoCard()">
                <i class="fas fa-times"></i>
            </button>
            <h3><i class="fas fa-info-circle"></i> Cara Presensi</h3>
            <p>Sebut nama siswa sesuai absen, lalu klik status kehadiran. Siswa yang sudah diabsen akan otomatis hilang dari daftar.</p>
        </div>
        
        <?php if (count($siswa_diabsen) > 0): ?>
        <div class="completed-card">
            <h3><i class="fas fa-check-circle"></i> Sudah Diabsen (<?php echo count($siswa_diabsen); ?>)</h3>
            <?php foreach ($siswa_diabsen as $item): ?>
            <div class="completed-item">
                <div class="completed-icon <?php echo $item['status']; ?>">
                    <i class="fas fa-<?php 
                        echo $item['status'] == 'hadir' ? 'check' : 
                            ($item['status'] == 'izin' ? 'envelope' : 
                            ($item['status'] == 'sakit' ? 'medkit' : 'times')); 
                    ?>"></i>
                </div>
                <div class="completed-info">
                    <div class="name"><?php echo $item['nama']; ?></div>
                    <div class="meta">
                        <?php echo $item['nis']; ?> • <?php echo $item['kelas']; ?> • 
                        <strong><?php echo ucfirst($item['status']); ?></strong>
                        <?php if ($item['keterangan']): ?>
                        • <?php echo $item['keterangan']; ?>
                        <?php endif; ?>
                    </div>
                </div>
                <button class="btn-edit-absen" onclick="openEditAbsenModal(<?php echo $item['siswa_id']; ?>, '<?php echo addslashes($item['nama']); ?>', '<?php echo $item['nis']; ?>', '<?php echo $item['kelas']; ?>', '<?php echo $item['status']; ?>', '<?php echo addslashes($item['keterangan']); ?>', '<?php echo $selected_date; ?>')">
                    <i class="fas fa-edit"></i>
                </button>
            </div>
            <?php endforeach; ?>
        </div>
        <?php endif; ?>
        
        <?php if (count($siswa_list) > 0): ?>
        <div class="section-title">
            <h3>Belum Diabsen</h3>
            <span class="count"><?php echo count($siswa_list); ?> siswa</span>
        </div>
        <?php endif; ?>
        
        <?php if (count($siswa_list) > 0): ?>
        <form method="POST" id="presensiForm">
            <input type="hidden" name="submit_presensi" value="1">
            <input type="hidden" name="tanggal" value="<?php echo $selected_date; ?>">
            
            <?php $no = 1; foreach ($siswa_list as $siswa): 
                $current_status = $presensi_data[$siswa['id']]['status'] ?? '';
                $current_keterangan = $presensi_data[$siswa['id']]['keterangan'] ?? '';
            ?>
            <div class="siswa-item">
                <div class="siswa-header">
                    <div class="siswa-number"><?php echo $no++; ?></div>
                    <div class="siswa-info">
                        <h4><?php echo $siswa['nama']; ?></h4>
                        <div class="meta">
                            <span><i class="fas fa-id-card"></i> <?php echo $siswa['nis']; ?></span>
                            <span><i class="fas fa-school"></i> <?php echo $siswa['kelas']; ?></span>
                        </div>
                    </div>
                </div>
                
                <div class="status-buttons">
                    <label class="status-btn <?php echo $current_status == 'hadir' ? 'hadir' : ''; ?>" onclick="selectStatus(this, <?php echo $siswa['id']; ?>)">
                        <i class="fas fa-check-circle"></i>
                        <span>Hadir</span>
                        <input type="radio" name="status[<?php echo $siswa['id']; ?>]" value="hadir" <?php echo $current_status == 'hadir' ? 'checked' : ''; ?>>
                    </label>
                    
                    <label class="status-btn <?php echo $current_status == 'izin' ? 'izin' : ''; ?>" onclick="selectStatus(this, <?php echo $siswa['id']; ?>)">
                        <i class="fas fa-envelope"></i>
                        <span>Izin</span>
                        <input type="radio" name="status[<?php echo $siswa['id']; ?>]" value="izin" <?php echo $current_status == 'izin' ? 'checked' : ''; ?>>
                    </label>
                    
                    <label class="status-btn <?php echo $current_status == 'sakit' ? 'sakit' : ''; ?>" onclick="selectStatus(this, <?php echo $siswa['id']; ?>)">
                        <i class="fas fa-medkit"></i>
                        <span>Sakit</span>
                        <input type="radio" name="status[<?php echo $siswa['id']; ?>]" value="sakit" <?php echo $current_status == 'sakit' ? 'checked' : ''; ?>>
                    </label>
                    
                    <label class="status-btn <?php echo $current_status == 'alpha' ? 'alpha' : ''; ?>" onclick="selectStatus(this, <?php echo $siswa['id']; ?>)">
                        <i class="fas fa-times-circle"></i>
                        <span>Alpha</span>
                        <input type="radio" name="status[<?php echo $siswa['id']; ?>]" value="alpha" <?php echo $current_status == 'alpha' ? 'checked' : ''; ?>>
                    </label>
                </div>
                
                <div class="keterangan-box <?php echo in_array($current_status, ['izin', 'sakit', 'alpha']) ? 'show' : ''; ?>" id="ket_<?php echo $siswa['id']; ?>">
                    <textarea name="keterangan[<?php echo $siswa['id']; ?>]" placeholder="Keterangan (opsional)..."><?php echo $current_keterangan; ?></textarea>
                </div>
            </div>
            <?php endforeach; ?>
        </form>
        
        <?php else: ?>
        <div class="empty-state">
            <i class="fas fa-clipboard-check"></i>
            <p>
                <?php if (count($siswa_diabsen) > 0): ?>
                    Semua siswa sudah diabsen!<br>
                    Total: <?php echo count($siswa_diabsen); ?> siswa
                <?php else: ?>
                    Belum ada data siswa.<br>Tambahkan siswa terlebih dahulu untuk melakukan presensi.
                <?php endif; ?>
            </p>
            <?php if (count($siswa_diabsen) == 0): ?>
            <a href="siswa.php" class="btn-link">
                <i class="fas fa-plus-circle"></i> Tambah Siswa
            </a>
            <?php endif; ?>
        </div>
        <?php endif; ?>
    </div>
    
    <div class="bottom-nav">
        <a href="dashboard.php" class="nav-item">
            <i class="fas fa-home"></i>
            <span>Home</span>
        </a>
        <a href="presensi.php" class="nav-item active">
            <i class="fas fa-clipboard-check"></i>
            <span>Presensi</span>
        </a>
        <a href="siswa.php" class="nav-item">
            <i class="fas fa-users"></i>
            <span>Siswa</span>
        </a>
        <a href="reporting.php" class="nav-item">
            <i class="fas fa-chart-bar"></i>
            <span>Laporan</span>
        </ul>
    </div>
    
    <div class="loading-overlay" id="loadingOverlay">
        <div class="loading-content">
            <div class="loading-spinner"></div>
            <div class="loading-text">Menyimpan presensi...</div>
        </div>
    </div>

    <!-- Edit Attendance Modal -->
    <div id="editModal" class="modal">
        <div class="modal-content">
            <div class="modal-header">
                <h3>Edit Absensi</h3>
                <button class="btn-close" onclick="closeEditModal()"><i class="fas fa-times"></i></button>
            </div>
            <form method="POST" id="editForm">
                <input type="hidden" name="action" value="edit_absensi">
                <input type="hidden" name="siswa_id" id="edit_siswa_id">
                <input type="hidden" name="tanggal" id="edit_tanggal">
                
                <div class="modal-body">
                    <div class="student-info-box">
                        <h4 id="edit_nama_siswa">-</h4>
                        <p id="edit_detail_siswa">-</p>
                    </div>
                    
                    <div class="form-group">
                        <label>Status Kehadiran</label>
                        <div class="status-options">
                            <div>
                                <input type="radio" name="status" value="Hadir" id="edit_hadir" class="status-option">
                                <label for="edit_hadir" class="status-option-label hadir">
                                    <i class="fas fa-check"></i>
                                    <span>Hadir</span>
                                </label>
                            </div>
                            <div>
                                <input type="radio" name="status" value="Izin" id="edit_izin" class="status-option">
                                <label for="edit_izin" class="status-option-label izin">
                                    <i class="fas fa-envelope"></i>
                                    <span>Izin</span>
                                </label>
                            </div>
                            <div>
                                <input type="radio" name="status" value="Sakit" id="edit_sakit" class="status-option">
                                <label for="edit_sakit" class="status-option-label sakit">
                                    <i class="fas fa-notes-medical"></i>
                                    <span>Sakit</span>
                                </label>
                            </div>
                            <div>
                                <input type="radio" name="status" value="Alpha" id="edit_alpha" class="status-option">
                                <label for="edit_alpha" class="status-option-label alpha">
                                    <i class="fas fa-times"></i>
                                    <span>Alpha</span>
                                </label>
                            </div>
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <label>Keterangan (Opsional)</label>
                        <textarea name="keterangan" id="edit_keterangan" placeholder="Tambahkan keterangan jika diperlukan..."></textarea>
                    </div>
                </div>
                
                <div class="modal-footer">
                    <button type="button" class="btn-secondary" onclick="closeEditModal()">Batal</button>
                    <button type="submit" class="btn-primary">Simpan Perubahan</button>
                </div>
            </form>
        </div>
    </div>

    <script>
        function openEditAbsenModal(siswaId, nama, nis, kelas, status, keterangan, tanggal) {
            console.log('Opening modal with:', {siswaId, nama, nis, kelas, status, keterangan, tanggal});
            
            document.getElementById('edit_siswa_id').value = siswaId;
            document.getElementById('edit_tanggal').value = tanggal;
            document.getElementById('edit_nama_siswa').textContent = nama;
            document.getElementById('edit_detail_siswa').textContent = 'NIS: ' + nis + ' • Kelas: ' + kelas;
            
            // Set status radio button
            const statusLower = status.toLowerCase();
            if (statusLower === 'hadir') {
                document.getElementById('edit_hadir').checked = true;
            } else if (statusLower === 'izin') {
                document.getElementById('edit_izin').checked = true;
            } else if (statusLower === 'sakit') {
                document.getElementById('edit_sakit').checked = true;
            } else if (statusLower === 'alpha') {
                document.getElementById('edit_alpha').checked = true;
            }
            
            // Set keterangan
            document.getElementById('edit_keterangan').value = keterangan || '';
            
            // Show modal
            document.getElementById('editModal').classList.add('active');
        }
        
        function closeEditModal() {
            document.getElementById('editModal').classList.remove('active');
        }
        
        // Close modal when clicking outside
        document.getElementById('editModal').addEventListener('click', function(e) {
            if (e.target === this) {
                closeEditModal();
            }
        });
        
        // Handle edit form submit
        document.getElementById('editForm').addEventListener('submit', function(e) {
            e.preventDefault();
            console.log('Form submitting...');
            document.getElementById('loadingOverlay').classList.add('active');
            setTimeout(() => {
                this.submit();
            }, 300);
        });
        
        function selectStatus(button, siswaId) {
            // Remove all status classes from siblings
            const siblings = button.parentElement.querySelectorAll('.status-btn');
            siblings.forEach(sib => {
                sib.classList.remove('hadir', 'izin', 'sakit', 'alpha');
            });
            
            // Add appropriate class
            const status = button.querySelector('input').value;
            button.classList.add(status);
            
            // Show/hide keterangan box
            const ketBox = document.getElementById('ket_' + siswaId);
            if (status === 'izin' || status === 'sakit' || status === 'alpha') {
                ketBox.classList.add('show');
            } else {
                ketBox.classList.remove('show');
            }
            
            // Show loading and auto submit
            document.getElementById('loadingOverlay').classList.add('active');
            setTimeout(() => {
                document.getElementById('presensiForm').submit();
            }, 300);
        }
        
        function changeTanggal() {
            const tanggal = document.getElementById('tanggalInput').value;
            window.location.href = 'presensi.php?tanggal=' + tanggal;
        }
        
        function closeInfoCard() {
            document.getElementById('infoCard').classList.remove('show');
            localStorage.setItem('hideInfoCard', 'true');
        }
        
        // Check if info card should be shown
        window.addEventListener('DOMContentLoaded', function() {
            const hideInfo = localStorage.getItem('hideInfoCard');
            if (!hideInfo) {
                document.getElementById('infoCard').classList.add('show');
            }
        });
    </script>
</body>
</html>
