<?php
session_start();
if (!isset($_SESSION['guru_id'])) {
    header('Location: ../login.php');
    exit();
}

require_once '../config/database.php';
$conn = getConnection();

$guru_id = $_SESSION['guru_id'];

// Get filter
$filter = $_GET['filter'] ?? 'harian';
$tanggal = $_GET['tanggal'] ?? date('Y-m-d');
$bulan = $_GET['bulan'] ?? date('Y-m');
$siswa_id = $_GET['siswa_id'] ?? '';

// Get siswa list for filter
$siswa_list = $conn->query("SELECT id, nama FROM siswa WHERE guru_id=$guru_id ORDER BY nama")->fetch_all(MYSQLI_ASSOC);

// Prepare query based on filter
if ($filter == 'harian') {
    $where = "WHERE a.guru_id=$guru_id AND DATE(a.tanggal) = '$tanggal'";
    $title = "Laporan Harian - " . date('d F Y', strtotime($tanggal));
} elseif ($filter == 'mingguan') {
    $start_week = date('Y-m-d', strtotime('monday this week', strtotime($tanggal)));
    $end_week = date('Y-m-d', strtotime('sunday this week', strtotime($tanggal)));
    $where = "WHERE a.guru_id=$guru_id AND a.tanggal BETWEEN '$start_week' AND '$end_week'";
    $title = "Laporan Mingguan - " . date('d M', strtotime($start_week)) . " s/d " . date('d M Y', strtotime($end_week));
} else { // bulanan
    $start_month = $bulan . '-01';
    $end_month = date('Y-m-t', strtotime($start_month));
    $where = "WHERE a.guru_id=$guru_id AND a.tanggal BETWEEN '$start_month' AND '$end_month'";
    $title = "Laporan Bulanan - " . date('F Y', strtotime($start_month));
}

if ($siswa_id) {
    $where .= " AND a.siswa_id = $siswa_id";
}

// Get summary statistics
$stats = $conn->query("
    SELECT 
        SUM(CASE WHEN a.status='hadir' THEN 1 ELSE 0 END) as total_hadir,
        SUM(CASE WHEN a.status='izin' THEN 1 ELSE 0 END) as total_izin,
        SUM(CASE WHEN a.status='sakit' THEN 1 ELSE 0 END) as total_sakit,
        SUM(CASE WHEN a.status='alpha' THEN 1 ELSE 0 END) as total_alpha
    FROM absensi a
    $where
")->fetch_assoc();

// Get detailed data
$detail_data = $conn->query("
    SELECT 
        s.nama as siswa_nama,
        s.nis,
        s.kelas,
        a.tanggal,
        a.status,
        a.keterangan
    FROM absensi a
    JOIN siswa s ON a.siswa_id = s.id
    $where
    ORDER BY a.tanggal DESC, s.nama ASC
")->fetch_all(MYSQLI_ASSOC);

// Get data for pie chart
$chart_data = [
    'hadir' => $stats['total_hadir'] ?? 0,
    'izin' => $stats['total_izin'] ?? 0,
    'sakit' => $stats['total_sakit'] ?? 0,
    'alpha' => $stats['total_alpha'] ?? 0
];

$conn->close();
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Laporan - SIPANCUR MOBILE</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Poppins', sans-serif;
            background: #f3f4f6;
            padding-bottom: 80px;
        }
        
        .header {
            background: linear-gradient(135deg, #4ade80 0%, #22c55e 100%);
            color: white;
            padding: 20px;
            box-shadow: 0 2px 15px rgba(0,0,0,0.1);
            position: sticky;
            top: 0;
            z-index: 100;
        }
        
        .header-content {
            display: flex;
            align-items: center;
            gap: 15px;
        }
        
        .btn-back {
            width: 40px;
            height: 40px;
            background: rgba(255,255,255,0.2);
            border-radius: 10px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 18px;
            color: white;
            text-decoration: none;
        }
        
        .header-title h1 {
            font-size: 20px;
            font-weight: 700;
        }
        
        .header-title p {
            font-size: 13px;
            opacity: 0.9;
        }
        
        .container {
            padding: 20px;
            max-width: 600px;
            margin: 0 auto;
        }
        
        .filter-card {
            background: white;
            border-radius: 18px;
            padding: 20px;
            margin-bottom: 20px;
            box-shadow: 0 4px 15px rgba(0,0,0,0.08);
        }
        
        .filter-card h3 {
            color: #1f2937;
            font-size: 16px;
            margin-bottom: 15px;
            font-weight: 600;
        }
        
        .form-group {
            margin-bottom: 15px;
        }
        
        .form-group label {
            display: block;
            color: #6b7280;
            font-size: 13px;
            font-weight: 500;
            margin-bottom: 8px;
        }
        
        .form-group select,
        .form-group input {
            width: 100%;
            padding: 12px 15px;
            border: 2px solid #e5e7eb;
            border-radius: 10px;
            font-size: 14px;
            font-family: 'Poppins', sans-serif;
        }
        
        .form-group select:focus,
        .form-group input:focus {
            outline: none;
            border-color: #4ade80;
        }
        
        .btn-filter {
            width: 100%;
            background: linear-gradient(135deg, #4ade80 0%, #22c55e 100%);
            color: white;
            padding: 14px;
            border: none;
            border-radius: 12px;
            font-size: 15px;
            font-weight: 600;
            cursor: pointer;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 8px;
            margin-top: 10px;
        }
        
        .btn-filter:active {
            transform: scale(0.98);
        }
        
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 15px;
            margin-bottom: 20px;
        }
        
        .stat-card {
            background: white;
            border-radius: 18px;
            padding: 20px;
            box-shadow: 0 4px 15px rgba(0,0,0,0.08);
        }
        
        .stat-card .icon {
            width: 50px;
            height: 50px;
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 24px;
            margin-bottom: 12px;
        }
        
        .stat-card.green .icon {
            background: rgba(34, 197, 94, 0.12);
            color: #22c55e;
        }
        
        .stat-card.blue .icon {
            background: rgba(59, 130, 246, 0.12);
            color: #3b82f6;
        }
        
        .stat-card.yellow .icon {
            background: rgba(234, 179, 8, 0.12);
            color: #eab308;
        }
        
        .stat-card.red .icon {
            background: rgba(239, 68, 68, 0.12);
            color: #ef4444;
        }
        
        .stat-card .label {
            color: #6b7280;
            font-size: 12px;
            margin-bottom: 5px;
            font-weight: 500;
        }
        
        .stat-card .value {
            color: #1f2937;
            font-size: 26px;
            font-weight: 700;
        }
        
        .chart-card {
            background: white;
            border-radius: 18px;
            padding: 20px;
            box-shadow: 0 4px 15px rgba(0,0,0,0.08);
            margin-bottom: 20px;
        }
        
        .chart-card h3 {
            color: #1f2937;
            font-size: 16px;
            margin-bottom: 20px;
            font-weight: 600;
        }
        
        .data-card {
            background: white;
            border-radius: 18px;
            padding: 20px;
            box-shadow: 0 4px 15px rgba(0,0,0,0.08);
        }
        
        .data-card h3 {
            color: #1f2937;
            font-size: 16px;
            margin-bottom: 15px;
            font-weight: 600;
        }
        
        .data-item {
            padding: 15px;
            border-bottom: 1px solid #f3f4f6;
            display: flex;
            justify-content: space-between;
            align-items: start;
        }
        
        .data-item:last-child {
            border-bottom: none;
        }
        
        .data-info h4 {
            color: #1f2937;
            font-size: 14px;
            font-weight: 600;
            margin-bottom: 6px;
        }
        
        .data-meta {
            display: flex;
            flex-wrap: wrap;
            gap: 10px;
            font-size: 12px;
            color: #6b7280;
        }
        
        .data-meta span {
            display: flex;
            align-items: center;
            gap: 4px;
        }
        
        .badge {
            padding: 6px 12px;
            border-radius: 20px;
            font-size: 11px;
            font-weight: 600;
            white-space: nowrap;
        }
        
        .badge.hadir {
            background: #d1fae5;
            color: #065f46;
        }
        
        .badge.izin {
            background: #dbeafe;
            color: #1e40af;
        }
        
        .badge.sakit {
            background: #fef3c7;
            color: #92400e;
        }
        
        .badge.alpha {
            background: #fee2e2;
            color: #991b1b;
        }
        
        .bottom-nav {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            background: white;
            box-shadow: 0 -2px 15px rgba(0,0,0,0.1);
            padding: 12px 20px;
            display: flex;
            justify-content: space-around;
            z-index: 100;
        }
        
        .nav-item {
            display: flex;
            flex-direction: column;
            align-items: center;
            gap: 5px;
            text-decoration: none;
            color: #9ca3af;
            transition: all 0.3s;
            padding: 8px 15px;
            border-radius: 12px;
            flex: 1;
            max-width: 80px;
        }
        
        .nav-item.active {
            color: #22c55e;
            background: rgba(74, 222, 128, 0.1);
        }
        
        .nav-item i {
            font-size: 22px;
        }
        
        .nav-item span {
            font-size: 11px;
            font-weight: 500;
        }
        
        .empty-state {
            text-align: center;
            padding: 40px 20px;
            color: #9ca3af;
        }
        
        .empty-state i {
            font-size: 48px;
            margin-bottom: 10px;
            opacity: 0.5;
        }
        
        .empty-state p {
            font-size: 13px;
        }
    </style>
</head>
<body>
    <div class="header">
        <div class="header-content">
            <a href="dashboard.php" class="btn-back">
                <i class="fas fa-arrow-left"></i>
            </a>
            <div class="header-title">
                <h1>Laporan Absensi</h1>
                <p>Rekapitulasi Kehadiran</p>
            </div>
        </div>
    </div>
    
    <div class="container">
        <div class="filter-card">
            <h3><i class="fas fa-filter"></i> Filter Laporan</h3>
            <form method="GET">
                <div class="form-group">
                    <label>Tipe Laporan</label>
                    <select name="filter" id="filterType" onchange="updateDateInput()">
                        <option value="harian" <?php echo $filter == 'harian' ? 'selected' : ''; ?>>Harian</option>
                        <option value="mingguan" <?php echo $filter == 'mingguan' ? 'selected' : ''; ?>>Mingguan</option>
                        <option value="bulanan" <?php echo $filter == 'bulanan' ? 'selected' : ''; ?>>Bulanan</option>
                    </select>
                </div>
                
                <div class="form-group" id="tanggalGroup">
                    <label>Tanggal</label>
                    <input type="date" name="tanggal" value="<?php echo $tanggal; ?>">
                </div>
                
                <div class="form-group" id="bulanGroup" style="display: none;">
                    <label>Bulan</label>
                    <input type="month" name="bulan" value="<?php echo $bulan; ?>">
                </div>
                
                <div class="form-group">
                    <label>Siswa</label>
                    <select name="siswa_id">
                        <option value="">Semua Siswa</option>
                        <?php foreach ($siswa_list as $siswa): ?>
                            <option value="<?php echo $siswa['id']; ?>" <?php echo $siswa_id == $siswa['id'] ? 'selected' : ''; ?>>
                                <?php echo $siswa['nama']; ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                
                <button type="submit" class="btn-filter">
                    <i class="fas fa-search"></i> Tampilkan Laporan
                </button>
            </form>
            
            <?php if (count($detail_data) > 0): ?>
            <div style="margin-top: 15px; display: flex; gap: 10px;">
                <a href="export_pdf.php?<?php echo http_build_query($_GET); ?>" target="_blank" class="btn-export" style="flex: 1; background: #ef4444; color: white; text-decoration: none; padding: 12px; border-radius: 12px; text-align: center; font-weight: 600; font-size: 14px; display: flex; align-items: center; justify-content: center; gap: 8px;">
                    <i class="fas fa-file-pdf"></i> Export PDF
                </a>
                <a href="export_excel.php?<?php echo http_build_query($_GET); ?>" class="btn-export" style="flex: 1; background: #22c55e; color: white; text-decoration: none; padding: 12px; border-radius: 12px; text-align: center; font-weight: 600; font-size: 14px; display: flex; align-items: center; justify-content: center; gap: 8px;">
                    <i class="fas fa-file-excel"></i> Export Excel
                </a>
            </div>
            <?php endif; ?>
        </div>
        
        <div class="stats-grid">
            <div class="stat-card green">
                <div class="icon"><i class="fas fa-check-circle"></i></div>
                <div class="label">Hadir</div>
                <div class="value"><?php echo $chart_data['hadir']; ?></div>
            </div>
            
            <div class="stat-card blue">
                <div class="icon"><i class="fas fa-envelope"></i></div>
                <div class="label">Izin</div>
                <div class="value"><?php echo $chart_data['izin']; ?></div>
            </div>
            
            <div class="stat-card yellow">
                <div class="icon"><i class="fas fa-medkit"></i></div>
                <div class="label">Sakit</div>
                <div class="value"><?php echo $chart_data['sakit']; ?></div>
            </div>
            
            <div class="stat-card red">
                <div class="icon"><i class="fas fa-times-circle"></i></div>
                <div class="label">Alpha</div>
                <div class="value"><?php echo $chart_data['alpha']; ?></div>
            </div>
        </div>
        
        <div class="chart-card">
            <h3><i class="fas fa-chart-pie"></i> Grafik Kehadiran</h3>
            <canvas id="pieChart"></canvas>
        </div>
        
        <div class="data-card">
            <h3><i class="fas fa-list"></i> <?php echo $title; ?></h3>
            <?php if (count($detail_data) > 0): ?>
                <?php foreach ($detail_data as $data): ?>
                <div class="data-item">
                    <div class="data-info">
                        <h4><?php echo $data['siswa_nama']; ?></h4>
                        <div class="data-meta">
                            <span><i class="fas fa-calendar"></i> <?php echo date('d/m/Y', strtotime($data['tanggal'])); ?></span>
                            <span><i class="fas fa-id-card"></i> <?php echo $data['nis']; ?></span>
                            <span><i class="fas fa-school"></i> <?php echo $data['kelas']; ?></span>
                        </div>
                        <?php if ($data['keterangan']): ?>
                        <div class="data-meta" style="margin-top: 5px;">
                            <span style="color: #9ca3af;"><i class="fas fa-comment"></i> <?php echo $data['keterangan']; ?></span>
                        </div>
                        <?php endif; ?>
                    </div>
                    <span class="badge <?php echo $data['status']; ?>">
                        <?php echo ucfirst($data['status']); ?>
                    </span>
                </div>
                <?php endforeach; ?>
            <?php else: ?>
                <div class="empty-state">
                    <i class="fas fa-inbox"></i>
                    <p>Tidak ada data untuk periode yang dipilih</p>
                </div>
            <?php endif; ?>
        </div>
    </div>
    
    <div class="bottom-nav">
        <a href="dashboard.php" class="nav-item">
            <i class="fas fa-home"></i>
            <span>Home</span>
        </a>
        <a href="presensi.php" class="nav-item">
            <i class="fas fa-clipboard-check"></i>
            <span>Presensi</span>
        </a>
        <a href="siswa.php" class="nav-item">
            <i class="fas fa-users"></i>
            <span>Siswa</span>
        </a>
        <a href="reporting.php" class="nav-item active">
            <i class="fas fa-chart-bar"></i>
            <span>Laporan</span>
        </a>
    </div>
    
    <script>
        function updateDateInput() {
            const filter = document.getElementById('filterType').value;
            const tanggalGroup = document.getElementById('tanggalGroup');
            const bulanGroup = document.getElementById('bulanGroup');
            
            if (filter === 'bulanan') {
                tanggalGroup.style.display = 'none';
                bulanGroup.style.display = 'block';
            } else {
                tanggalGroup.style.display = 'block';
                bulanGroup.style.display = 'none';
            }
        }
        
        updateDateInput();
        
        // Pie Chart
        const ctx = document.getElementById('pieChart').getContext('2d');
        const chartData = <?php echo json_encode($chart_data); ?>;
        
        new Chart(ctx, {
            type: 'doughnut',
            data: {
                labels: ['Hadir', 'Izin', 'Sakit', 'Alpha'],
                datasets: [{
                    data: [chartData.hadir, chartData.izin, chartData.sakit, chartData.alpha],
                    backgroundColor: ['#22c55e', '#3b82f6', '#eab308', '#ef4444'],
                    borderWidth: 0
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: true,
                plugins: {
                    legend: {
                        position: 'bottom',
                        labels: {
                            font: {
                                family: 'Poppins',
                                size: 12,
                                weight: '500'
                            },
                            usePointStyle: true,
                            padding: 15
                        }
                    }
                }
            }
        });
    </script>
</body>
</html>
