<?php
session_start();
if (!isset($_SESSION['guru_id'])) {
    header('Location: ../login.php');
    exit();
}

require_once '../config/database.php';
$conn = getConnection();

$guru_id = $_SESSION['guru_id'];

// Handle actions
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (isset($_POST['action'])) {
        if ($_POST['action'] == 'add') {
            $nis = $_POST['nis'];
            $nama = $_POST['nama'];
            $kelas = $_POST['kelas'];
            $jenis_kelamin = $_POST['jenis_kelamin'];
            
            $stmt = $conn->prepare("INSERT INTO siswa (nis, nama, kelas, jenis_kelamin, guru_id) VALUES (?, ?, ?, ?, ?)");
            $stmt->bind_param("ssssi", $nis, $nama, $kelas, $jenis_kelamin, $guru_id);
            
            if ($stmt->execute()) {
                $success = "Siswa berhasil ditambahkan!";
            } else {
                $error = "Gagal menambahkan siswa: " . $stmt->error;
            }
            $stmt->close();
        } elseif ($_POST['action'] == 'edit') {
            $id = $_POST['id'];
            $nis = $_POST['nis'];
            $nama = $_POST['nama'];
            $kelas = $_POST['kelas'];
            $jenis_kelamin = $_POST['jenis_kelamin'];
            $status = $_POST['status'];
            
            $stmt = $conn->prepare("UPDATE siswa SET nis=?, nama=?, kelas=?, jenis_kelamin=?, status=? WHERE id=? AND guru_id=?");
            $stmt->bind_param("sssssii", $nis, $nama, $kelas, $jenis_kelamin, $status, $id, $guru_id);
            
            if ($stmt->execute()) {
                $success = "Data siswa berhasil diupdate!";
            } else {
                $error = "Gagal mengupdate siswa: " . $stmt->error;
            }
            $stmt->close();
        } elseif ($_POST['action'] == 'delete') {
            $id = $_POST['id'];
            $stmt = $conn->prepare("DELETE FROM siswa WHERE id=? AND guru_id=?");
            $stmt->bind_param("ii", $id, $guru_id);
            
            if ($stmt->execute()) {
                $success = "Siswa berhasil dihapus!";
            } else {
                $error = "Gagal menghapus siswa: " . $stmt->error;
            }
            $stmt->close();
        }
    }
}

// Get filter
$kelas_filter = $_GET['kelas'] ?? '';

// Get all siswa with filter
$query = "SELECT * FROM siswa WHERE guru_id = $guru_id";
if ($kelas_filter) {
    $query .= " AND kelas = '" . $conn->real_escape_string($kelas_filter) . "'";
}
$query .= " ORDER BY kelas ASC, nama ASC";
$siswa_list = $conn->query($query)->fetch_all(MYSQLI_ASSOC);

// Get kelas list for filter
$kelas_list = $conn->query("SELECT DISTINCT kelas FROM siswa WHERE guru_id = $guru_id AND kelas IS NOT NULL AND kelas != '' ORDER BY kelas")->fetch_all(MYSQLI_ASSOC);

$conn->close();
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Data Siswa - SIPANCUR MOBILE</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Poppins', sans-serif;
            background: #f3f4f6;
            padding-bottom: 80px;
        }
        
        .header {
            background: linear-gradient(135deg, #4ade80 0%, #22c55e 100%);
            color: white;
            padding: 20px;
            box-shadow: 0 2px 15px rgba(0,0,0,0.1);
            position: sticky;
            top: 0;
            z-index: 100;
        }
        
        .header-content {
            display: flex;
            align-items: center;
            justify-content: space-between;
        }
        
        .header-left {
            display: flex;
            align-items: center;
            gap: 15px;
        }
        
        .btn-back {
            width: 40px;
            height: 40px;
            background: rgba(255,255,255,0.2);
            border-radius: 10px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 18px;
            color: white;
            text-decoration: none;
        }
        
        .header-title h1 {
            font-size: 20px;
            font-weight: 700;
        }
        
        .header-title p {
            font-size: 13px;
            opacity: 0.9;
        }
        
        .container {
            padding: 20px;
            max-width: 600px;
            margin: 0 auto;
        }
        
        .alert {
            padding: 15px 18px;
            border-radius: 12px;
            margin-bottom: 20px;
            display: flex;
            align-items: center;
            gap: 10px;
            font-size: 14px;
        }
        
        .alert.success {
            background: #d1fae5;
            color: #065f46;
        }
        
        .alert.error {
            background: #fee2e2;
            color: #991b1b;
        }
        
        .btn-add {
            background: linear-gradient(135deg, #4ade80 0%, #22c55e 100%);
            color: white;
            padding: 15px 25px;
            border: none;
            border-radius: 14px;
            font-size: 15px;
            font-weight: 600;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 10px;
            width: 100%;
            margin-bottom: 20px;
            box-shadow: 0 4px 15px rgba(74, 222, 128, 0.3);
            cursor: pointer;
        }
        
        .btn-add:active {
            transform: scale(0.98);
        }
        
        .search-box {
            margin-bottom: 20px;
        }
        
        .search-box input {
            width: 100%;
            padding: 15px 20px;
            border: 2px solid #e5e7eb;
            border-radius: 14px;
            font-size: 14px;
            font-family: 'Poppins', sans-serif;
        }
        
        .search-box input:focus {
            outline: none;
            border-color: #4ade80;
        }
        
        .siswa-card {
            background: white;
            border-radius: 18px;
            padding: 20px;
            margin-bottom: 15px;
            box-shadow: 0 4px 15px rgba(0,0,0,0.08);
        }
        
        .siswa-header {
            display: flex;
            justify-content: space-between;
            align-items: start;
            margin-bottom: 15px;
        }
        
        .siswa-info h3 {
            color: #1f2937;
            font-size: 17px;
            font-weight: 600;
            margin-bottom: 5px;
        }
        
        .siswa-info .nis {
            color: #6b7280;
            font-size: 13px;
            display: flex;
            align-items: center;
            gap: 5px;
        }
        
        .badge {
            padding: 5px 12px;
            border-radius: 20px;
            font-size: 11px;
            font-weight: 500;
        }
        
        .badge.success {
            background: #d1fae5;
            color: #065f46;
        }
        
        .badge.danger {
            background: #fee2e2;
            color: #991b1b;
        }
        
        .badge.info {
            background: #dbeafe;
            color: #1e40af;
        }
        
        .siswa-details {
            display: grid;
            gap: 10px;
            margin-bottom: 15px;
        }
        
        .detail-item {
            display: flex;
            align-items: center;
            gap: 10px;
            color: #6b7280;
            font-size: 13px;
        }
        
        .detail-item i {
            width: 20px;
            color: #22c55e;
        }
        
        .siswa-actions {
            display: flex;
            gap: 10px;
        }
        
        .btn-action {
            flex: 1;
            padding: 10px;
            border: none;
            border-radius: 10px;
            font-size: 13px;
            font-weight: 500;
            cursor: pointer;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 6px;
        }
        
        .btn-edit {
            background: #dbeafe;
            color: #1e40af;
        }
        
        .btn-delete {
            background: #fee2e2;
            color: #991b1b;
        }
        
        .btn-action:active {
            transform: scale(0.95);
        }
        
        .modal {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0,0,0,0.5);
            z-index: 1000;
            overflow-y: auto;
            padding: 20px;
        }
        
        .modal.active {
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .modal-content {
            background: white;
            border-radius: 20px;
            padding: 25px;
            max-width: 500px;
            width: 100%;
            max-height: 90vh;
            overflow-y: auto;
        }
        
        .modal-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 25px;
        }
        
        .modal-header h3 {
            color: #1f2937;
            font-size: 20px;
            font-weight: 600;
        }
        
        .btn-close {
            background: #f3f4f6;
            border: none;
            width: 35px;
            height: 35px;
            border-radius: 10px;
            cursor: pointer;
            display: flex;
            align-items: center;
            justify-content: center;
            color: #6b7280;
            font-size: 18px;
        }
        
        .form-group {
            margin-bottom: 18px;
        }
        
        .form-group label {
            display: block;
            color: #374151;
            font-weight: 500;
            margin-bottom: 8px;
            font-size: 13px;
        }
        
        .form-group input,
        .form-group select,
        .form-group textarea {
            width: 100%;
            padding: 12px 15px;
            border: 2px solid #e5e7eb;
            border-radius: 10px;
            font-size: 14px;
            font-family: 'Poppins', sans-serif;
        }
        
        .form-group input:focus,
        .form-group select:focus,
        .form-group textarea:focus {
            outline: none;
            border-color: #4ade80;
        }
        
        .form-group textarea {
            resize: vertical;
            min-height: 70px;
        }
        
        .form-row {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 12px;
        }
        
        .modal-footer {
            display: flex;
            gap: 10px;
            margin-top: 25px;
        }
        
        .btn-secondary {
            flex: 1;
            background: #e5e7eb;
            color: #374151;
            padding: 12px;
            border: none;
            border-radius: 10px;
            cursor: pointer;
            font-size: 14px;
            font-weight: 500;
        }
        
        .btn-primary {
            flex: 1;
            background: linear-gradient(135deg, #4ade80 0%, #22c55e 100%);
            color: white;
            padding: 12px;
            border: none;
            border-radius: 10px;
            cursor: pointer;
            font-size: 14px;
            font-weight: 500;
        }
        
        .bottom-nav {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            background: white;
            box-shadow: 0 -2px 15px rgba(0,0,0,0.1);
            padding: 12px 20px;
            display: flex;
            justify-content: space-around;
            z-index: 100;
        }
        
        .nav-item {
            display: flex;
            flex-direction: column;
            align-items: center;
            gap: 5px;
            text-decoration: none;
            color: #9ca3af;
            transition: all 0.3s;
            padding: 8px 15px;
            border-radius: 12px;
            flex: 1;
            max-width: 80px;
        }
        
        .nav-item.active {
            color: #22c55e;
            background: rgba(74, 222, 128, 0.1);
        }
        
        .nav-item i {
            font-size: 22px;
        }
        
        .nav-item span {
            font-size: 11px;
            font-weight: 500;
        }
        
        .empty-state {
            text-align: center;
            padding: 60px 20px;
            color: #9ca3af;
        }
        
        .empty-state i {
            font-size: 64px;
            margin-bottom: 15px;
            opacity: 0.5;
        }
        
        .empty-state p {
            font-size: 14px;
        }
    </style>
</head>
<body>
    <div class="header">
        <div class="header-content">
            <div class="header-left">
                <a href="dashboard.php" class="btn-back">
                    <i class="fas fa-arrow-left"></i>
                </a>
                <div class="header-title">
                    <h1>Data Siswa</h1>
                    <p><?php echo count($siswa_list); ?> siswa terdaftar</p>
                </div>
            </div>
        </div>
    </div>
    
    <div class="container">
        <?php if (isset($success)): ?>
        <div class="alert success">
            <i class="fas fa-check-circle"></i>
            <span><?php echo $success; ?></span>
        </div>
        <?php endif; ?>
        
        <?php if (isset($error)): ?>
        <div class="alert error">
            <i class="fas fa-exclamation-circle"></i>
            <span><?php echo $error; ?></span>
        </div>
        <?php endif; ?>
        
        <button class="btn-add" onclick="openAddModal()">
            <i class="fas fa-plus-circle"></i> Tambah Siswa Baru
        </button>
        
        <div class="search-box" style="margin-bottom: 15px;">
            <select id="kelasFilter" style="width: 100%; padding: 12px; border: 2px solid #667eea; border-radius: 15px; font-size: 14px; background: white;">
                <option value="">📚 Semua Kelas</option>
                <?php foreach ($kelas_list as $k): ?>
                    <option value="<?php echo $k['kelas']; ?>" <?php echo $kelas_filter == $k['kelas'] ? 'selected' : ''; ?>>
                        <?php echo $k['kelas']; ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>
        
        <div class="search-box">
            <input type="text" id="searchInput" placeholder="🔍 Cari nama atau NIS siswa..." onkeyup="searchSiswa()">
        </div>
        
        <div id="siswaList">
            <?php if (count($siswa_list) > 0): ?>
                <?php foreach ($siswa_list as $siswa): ?>
                <div class="siswa-card" data-nama="<?php echo strtolower($siswa['nama']); ?>" data-nis="<?php echo strtolower($siswa['nis']); ?>">
                    <div class="siswa-header">
                        <div class="siswa-info">
                            <h3><?php echo $siswa['nama']; ?></h3>
                            <div class="nis">
                                <i class="fas fa-id-card"></i>
                                <?php echo $siswa['nis']; ?>
                            </div>
                        </div>
                        <span class="badge <?php echo $siswa['status'] == 'aktif' ? 'success' : 'danger'; ?>">
                            <?php echo ucfirst($siswa['status']); ?>
                        </span>
                    </div>
                    
                    <div class="siswa-details">
                        <div class="detail-item">
                            <i class="fas fa-school"></i>
                            <span>Kelas: <?php echo $siswa['kelas']; ?></span>
                        </div>
                        <div class="detail-item">
                            <i class="fas fa-<?php echo $siswa['jenis_kelamin'] == 'Laki-laki' ? 'mars' : 'venus'; ?>"></i>
                            <span><?php echo $siswa['jenis_kelamin']; ?></span>
                        </div>
                    </div>
                    
                    <div class="siswa-actions">
                        <button class="btn-action btn-edit" onclick='openEditModal(<?php echo json_encode($siswa); ?>)'>
                            <i class="fas fa-edit"></i> Edit
                        </button>
                        <button class="btn-action btn-delete" onclick="deleteSiswa(<?php echo $siswa['id']; ?>, '<?php echo $siswa['nama']; ?>')">
                            <i class="fas fa-trash"></i> Hapus
                        </button>
                    </div>
                </div>
                <?php endforeach; ?>
            <?php else: ?>
                <div class="empty-state">
                    <i class="fas fa-user-graduate"></i>
                    <p>Belum ada data siswa.<br>Tambahkan siswa baru dengan tombol di atas.</p>
                </div>
            <?php endif; ?>
        </div>
    </div>
    
    <!-- Add Modal -->
    <div id="addModal" class="modal">
        <div class="modal-content">
            <div class="modal-header">
                <h3><i class="fas fa-user-plus"></i> Tambah Siswa</h3>
                <button class="btn-close" onclick="closeAddModal()">
                    <i class="fas fa-times"></i>
                </button>
            </div>
            <form method="POST">
                <input type="hidden" name="action" value="add">
                <div class="form-row">
                    <div class="form-group">
                        <label>NIS *</label>
                        <input type="text" name="nis" required>
                    </div>
                    <div class="form-group">
                        <label>Kelas *</label>
                        <input type="text" name="kelas" placeholder="Contoh: 1A" required>
                    </div>
                </div>
                <div class="form-group">
                    <label>Nama Lengkap *</label>
                    <input type="text" name="nama" required>
                </div>
                <div class="form-group">
                    <label>Jenis Kelamin *</label>
                    <select name="jenis_kelamin" required>
                        <option value="">Pilih Jenis Kelamin</option>
                        <option value="Laki-laki">Laki-laki</option>
                        <option value="Perempuan">Perempuan</option>
                    </select>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn-secondary" onclick="closeAddModal()">Batal</button>
                    <button type="submit" class="btn-primary">
                        <i class="fas fa-save"></i> Simpan
                    </button>
                </div>
            </form>
        </div>
    </div>
    
    <!-- Edit Modal -->
    <div id="editModal" class="modal">
        <div class="modal-content">
            <div class="modal-header">
                <h3><i class="fas fa-edit"></i> Edit Siswa</h3>
                <button class="btn-close" onclick="closeEditModal()">
                    <i class="fas fa-times"></i>
                </button>
            </div>
            <form method="POST">
                <input type="hidden" name="action" value="edit">
                <input type="hidden" name="id" id="edit_id">
                <div class="form-row">
                    <div class="form-group">
                        <label>NIS *</label>
                        <input type="text" name="nis" id="edit_nis" required>
                    </div>
                    <div class="form-group">
                        <label>Kelas *</label>
                        <input type="text" name="kelas" id="edit_kelas" required>
                    </div>
                </div>
                <div class="form-group">
                    <label>Nama Lengkap *</label>
                    <input type="text" name="nama" id="edit_nama" required>
                </div>
                <div class="form-group">
                    <label>Jenis Kelamin *</label>
                    <select name="jenis_kelamin" id="edit_jenis_kelamin" required>
                        <option value="">Pilih Jenis Kelamin</option>
                        <option value="Laki-laki">Laki-laki</option>
                        <option value="Perempuan">Perempuan</option>
                    </select>
                </div>
                <div class="form-group">
                    <label>Status *</label>
                    <select name="status" id="edit_status" required>
                        <option value="aktif">Aktif</option>
                        <option value="nonaktif">Non-Aktif</option>
                    </select>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn-secondary" onclick="closeEditModal()">Batal</button>
                    <button type="submit" class="btn-primary">
                        <i class="fas fa-save"></i> Update
                    </button>
                </div>
            </form>
        </div>
    </div>
    
    <!-- Delete Form -->
    <form method="POST" id="deleteForm" style="display: none;">
        <input type="hidden" name="action" value="delete">
        <input type="hidden" name="id" id="delete_id">
    </form>
    
    <div class="bottom-nav">
        <a href="dashboard.php" class="nav-item">
            <i class="fas fa-home"></i>
            <span>Home</span>
        </a>
        <a href="presensi.php" class="nav-item">
            <i class="fas fa-clipboard-check"></i>
            <span>Presensi</span>
        </a>
        <a href="siswa.php" class="nav-item active">
            <i class="fas fa-users"></i>
            <span>Siswa</span>
        </a>
        <a href="reporting.php" class="nav-item">
            <i class="fas fa-chart-bar"></i>
            <span>Laporan</span>
        </a>
    </div>
    
    <script>
        function openAddModal() {
            document.getElementById('addModal').classList.add('active');
        }
        
        function closeAddModal() {
            document.getElementById('addModal').classList.remove('active');
        }
        
        function openEditModal(siswa) {
            document.getElementById('edit_id').value = siswa.id;
            document.getElementById('edit_nis').value = siswa.nis;
            document.getElementById('edit_nama').value = siswa.nama;
            document.getElementById('edit_kelas').value = siswa.kelas;
            document.getElementById('edit_jenis_kelamin').value = siswa.jenis_kelamin;
            document.getElementById('edit_status').value = siswa.status;
            document.getElementById('editModal').classList.add('active');
        }
        
        function closeEditModal() {
            document.getElementById('editModal').classList.remove('active');
        }
        
        function deleteSiswa(id, nama) {
            if (confirm('Apakah Anda yakin ingin menghapus siswa ' + nama + '?')) {
                document.getElementById('delete_id').value = id;
                document.getElementById('deleteForm').submit();
            }
        }
        
        function searchSiswa() {
            const input = document.getElementById('searchInput').value.toLowerCase();
            const cards = document.querySelectorAll('.siswa-card');
            
            cards.forEach(card => {
                const nama = card.getAttribute('data-nama');
                const nis = card.getAttribute('data-nis');
                
                if (nama.includes(input) || nis.includes(input)) {
                    card.style.display = 'block';
                } else {
                    card.style.display = 'none';
                }
            });
        }
        
        // Filter by kelas
        document.getElementById('kelasFilter').addEventListener('change', function() {
            const kelas = this.value;
            if (kelas) {
                window.location.href = '?kelas=' + encodeURIComponent(kelas);
            } else {
                window.location.href = 'siswa.php';
            }
        });
        
        window.onclick = function(event) {
            if (event.target.classList.contains('modal')) {
                event.target.classList.remove('active');
            }
        }
    </script>
</body>
</html>
