<?php
// Database Installation Script
$host = 'localhost';
$user = 'root';
$pass = '';
$dbname = 'sipancur_db';

// Create connection
$conn = new mysqli($host, $user, $pass);

if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Create database
$sql = "CREATE DATABASE IF NOT EXISTS $dbname CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci";
if ($conn->query($sql) === TRUE) {
    echo "Database created successfully<br>";
} else {
    echo "Error creating database: " . $conn->error . "<br>";
}

$conn->select_db($dbname);

// Create admin table
$sql = "CREATE TABLE IF NOT EXISTS admin (
    id INT AUTO_INCREMENT PRIMARY KEY,
    username VARCHAR(50) UNIQUE NOT NULL,
    password VARCHAR(255) NOT NULL,
    nama VARCHAR(100) NOT NULL,
    email VARCHAR(100),
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4";

if ($conn->query($sql) === TRUE) {
    echo "Table admin created successfully<br>";
} else {
    echo "Error creating table: " . $conn->error . "<br>";
}

// Create guru table
$sql = "CREATE TABLE IF NOT EXISTS guru (
    id INT AUTO_INCREMENT PRIMARY KEY,
    nip VARCHAR(50) UNIQUE NOT NULL,
    username VARCHAR(50) UNIQUE NOT NULL,
    password VARCHAR(255) NOT NULL,
    nama VARCHAR(100) NOT NULL,
    email VARCHAR(100),
    telepon VARCHAR(20),
    alamat TEXT,
    foto VARCHAR(255) DEFAULT 'default.jpg',
    status ENUM('aktif', 'nonaktif') DEFAULT 'aktif',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4";

if ($conn->query($sql) === TRUE) {
    echo "Table guru created successfully<br>";
} else {
    echo "Error creating table: " . $conn->error . "<br>";
}

// Create siswa table
$sql = "CREATE TABLE IF NOT EXISTS siswa (
    id INT AUTO_INCREMENT PRIMARY KEY,
    nis VARCHAR(50) UNIQUE NOT NULL,
    nama VARCHAR(100) NOT NULL,
    kelas VARCHAR(20) NOT NULL,
    jenis_kelamin ENUM('L', 'P') NOT NULL,
    tanggal_lahir DATE,
    alamat TEXT,
    nama_ortu VARCHAR(100),
    telepon_ortu VARCHAR(20),
    foto VARCHAR(255) DEFAULT 'default.jpg',
    guru_id INT NOT NULL,
    status ENUM('aktif', 'nonaktif') DEFAULT 'aktif',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (guru_id) REFERENCES guru(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4";

if ($conn->query($sql) === TRUE) {
    echo "Table siswa created successfully<br>";
} else {
    echo "Error creating table: " . $conn->error . "<br>";
}

// Create absensi table
$sql = "CREATE TABLE IF NOT EXISTS absensi (
    id INT AUTO_INCREMENT PRIMARY KEY,
    siswa_id INT NOT NULL,
    guru_id INT NOT NULL,
    tanggal DATE NOT NULL,
    status ENUM('hadir', 'izin', 'sakit', 'alpha') NOT NULL,
    keterangan TEXT,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (siswa_id) REFERENCES siswa(id) ON DELETE CASCADE,
    FOREIGN KEY (guru_id) REFERENCES guru(id) ON DELETE CASCADE,
    UNIQUE KEY unique_absensi (siswa_id, tanggal)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4";

if ($conn->query($sql) === TRUE) {
    echo "Table absensi created successfully<br>";
} else {
    echo "Error creating table: " . $conn->error . "<br>";
}

// Insert default admin (username: admin, password: admin123)
$password = password_hash('admin123', PASSWORD_DEFAULT);
$sql = "INSERT INTO admin (username, password, nama, email) 
        VALUES ('admin', '$password', 'Administrator', 'admin@sipancur.com')
        ON DUPLICATE KEY UPDATE username=username";

if ($conn->query($sql) === TRUE) {
    echo "Default admin created successfully<br>";
    echo "<strong>Admin Login:</strong><br>";
    echo "Username: admin<br>";
    echo "Password: admin123<br><br>";
} else {
    echo "Error inserting admin: " . $conn->error . "<br>";
}

// Insert sample guru
$password = password_hash('guru123', PASSWORD_DEFAULT);
$sql = "INSERT INTO guru (nip, username, password, nama, email, telepon) 
        VALUES ('123456789', 'guru1', '$password', 'Budi Santoso', 'budi@sipancur.com', '08123456789')
        ON DUPLICATE KEY UPDATE nip=nip";

if ($conn->query($sql) === TRUE) {
    echo "Sample guru created successfully<br>";
    echo "<strong>Guru Login:</strong><br>";
    echo "Username: guru1<br>";
    echo "Password: guru123<br><br>";
} else {
    echo "Error inserting guru: " . $conn->error . "<br>";
}

echo "<hr>";
echo "<h3>Installation completed!</h3>";
echo "<p><a href='index.php' style='background: #4ade80; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px; display: inline-block;'>Go to Application</a></p>";

$conn->close();
?>
